/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Upgrades;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.slot.SlotRestrictedInput;
import appeng.fluids.container.ContainerFluidConfigurable;
import appeng.fluids.parts.PartFluidFormationPlane;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.items.IItemHandler;

public class ContainerFluidFormationPlane
extends ContainerFluidConfigurable {
    private final PartFluidFormationPlane plane;

    public ContainerFluidFormationPlane(InventoryPlayer ip, PartFluidFormationPlane te) {
        super(ip, te);
        this.plane = te;
    }

    @Override
    protected int getHeight() {
        return 251;
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.plane.getConfig();
    }

    @Override
    protected void setupConfig() {
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getInventoryPlayer()).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 4, 187, 80, this.getInventoryPlayer()).setNotDraggable());
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        this.checkToolbox();
        this.standardDetectAndSendChanges();
    }

    @Override
    protected boolean isValidForConfig(int slot, IAEFluidStack fs) {
        if (this.supportCapacity()) {
            int y = slot / 9;
            int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
            return y < upgrades + 2;
        }
        return true;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx;
    }

    @Override
    protected boolean supportCapacity() {
        return true;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }
}

