/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.container.slot.IJEITargetSlot;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketFluidSlot;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class GuiFluidSlot
extends GuiCustomSlot
implements IJEITargetSlot {
    private final IAEFluidTank fluids;
    private final int slot;

    public GuiFluidSlot(IAEFluidTank fluids, int slot, int id, int x, int y) {
        super(id, x, y);
        this.fluids = fluids;
        this.slot = slot;
    }

    @Override
    public void drawContent(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        IAEFluidStack fs = this.getFluidStack();
        if (fs != null) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
            Fluid fluid = fs.getFluid();
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite sprite = mc.func_147117_R().func_110572_b(fluid.getStill().toString());
            float red = (float)(fluid.getColor() >> 16 & 0xFF) / 255.0f;
            float green = (float)(fluid.getColor() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(fluid.getColor() & 0xFF) / 255.0f;
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            this.func_175175_a(this.xPos(), this.yPos(), sprite, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public boolean canClick(EntityPlayer player) {
        ItemStack mouseStack = player.field_71071_by.func_70445_o();
        return mouseStack.func_190926_b() || mouseStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    @Override
    public void slotClicked(ItemStack clickStack, int mouseButton) {
        FluidStack fluid;
        if (clickStack.func_190926_b() || mouseButton == 1) {
            this.setFluidStack(null);
        } else if (mouseButton == 0 && (fluid = FluidUtil.getFluidContained((ItemStack)clickStack)) != null) {
            this.setFluidStack(AEFluidStack.fromFluidStack(fluid));
        }
    }

    @Override
    public String getMessage() {
        IAEFluidStack fluid = this.getFluidStack();
        if (fluid != null) {
            return fluid.getFluidStack().getLocalizedName();
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public IAEFluidStack getFluidStack() {
        return this.fluids.getFluidInSlot(this.slot);
    }

    public void setFluidStack(IAEFluidStack stack) {
        this.fluids.setFluidInSlot(this.slot, stack);
        NetworkHandler.instance().sendToServer(new PacketFluidSlot(Collections.singletonMap(this.getId(), this.getFluidStack())));
    }

    @Override
    public boolean needAccept() {
        return this.getFluidStack() == null;
    }

    @Override
    public Object getIngredient() {
        return this.getFluidStack() == null ? null : this.getFluidStack().getFluidStack();
    }
}

