/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWirelessTermRegistry;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.GuiBridge;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public final class WirelessRegistry
implements IWirelessTermRegistry {
    private final List<IWirelessTermHandler> handlers = new ArrayList<IWirelessTermHandler>();

    @Override
    public void registerWirelessHandler(IWirelessTermHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    @Override
    public boolean isWirelessTerminal(ItemStack is) {
        for (IWirelessTermHandler h : this.handlers) {
            if (!h.canHandle(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IWirelessTermHandler getWirelessTerminalHandler(ItemStack is) {
        for (IWirelessTermHandler h : this.handlers) {
            if (!h.canHandle(is)) continue;
            return h;
        }
        return null;
    }

    @Override
    public void openWirelessTerminalGui(ItemStack item, World w, EntityPlayer player) {
        if (Platform.isClient()) {
            return;
        }
        if (!this.isWirelessTerminal(item)) {
            player.func_145747_a(PlayerMessages.DeviceNotWirelessTerminal.get());
            return;
        }
        IWirelessTermHandler handler = this.getWirelessTerminalHandler(item);
        String unparsedKey = handler.getEncryptionKey(item);
        if (unparsedKey.isEmpty()) {
            player.func_145747_a(PlayerMessages.DeviceNotLinked.get());
            return;
        }
        long parsedKey = Long.parseLong(unparsedKey);
        ILocatable securityStation = AEApi.instance().registries().locatable().getLocatableBy(parsedKey);
        if (securityStation == null) {
            player.func_145747_a(PlayerMessages.StationCanNotBeLocated.get());
            return;
        }
        if (handler.hasPower(player, 0.5, item)) {
            Platform.openGUI(player, null, null, (GuiBridge)handler.getGuiHandler(item));
        } else {
            player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
        }
    }
}

