/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridCacheRegistry;
import appeng.core.AELog;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public final class GridCacheRegistry
implements IGridCacheRegistry {
    private final Map<Class<? extends IGridCache>, Class<? extends IGridCache>> caches = new HashMap<Class<? extends IGridCache>, Class<? extends IGridCache>>();

    @Override
    public void registerGridCache(Class<? extends IGridCache> iface, Class<? extends IGridCache> implementation) {
        if (!iface.isAssignableFrom(implementation)) {
            throw new IllegalArgumentException("Invalid setup, grid cache must either be the same class, or an interface that the implementation implements. Gotten: " + iface + " and " + implementation);
        }
        this.caches.put(iface, implementation);
    }

    @Override
    public Map<Class<? extends IGridCache>, IGridCache> createCacheInstance(IGrid g) {
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        for (Class<? extends IGridCache> iface : this.caches.keySet()) {
            try {
                Constructor<? extends IGridCache> c = this.caches.get(iface).getConstructor(IGrid.class);
                map.put(iface, c.newInstance(g));
            }
            catch (NoSuchMethodException e) {
                AELog.error("Grid Caches must have a constructor with IGrid as the single param.", new Object[0]);
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                AELog.error("Grid Caches must have a constructor with IGrid as the single param.", new Object[0]);
                throw new IllegalStateException(e);
            }
            catch (InstantiationException e) {
                AELog.error("Grid Caches must have a constructor with IGrid as the single param.", new Object[0]);
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                AELog.error("Grid Caches must have a constructor with IGrid as the single param.", new Object[0]);
                throw new IllegalStateException(e);
            }
        }
        return map;
    }
}

