/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import appeng.util.Platform;
import com.google.common.base.Preconditions;

public class ApiGrid
implements IGridHelper {
    @Override
    public IGridNode createGridNode(IGridBlock blk) {
        Preconditions.checkNotNull((Object)blk);
        if (Platform.isClient()) {
            throw new IllegalStateException("Grid features for " + blk + " are server side only.");
        }
        return new GridNode(blk);
    }

    @Override
    public IGridConnection createGridConnection(IGridNode a, IGridNode b) throws FailedConnectionException {
        Preconditions.checkNotNull((Object)a);
        Preconditions.checkNotNull((Object)b);
        return GridConnection.create(a, b, AEPartLocation.INTERNAL);
    }
}

