/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.misc.PartOreDicStorageBus;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.item.OreReference;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ContainerOreDictStorageBus
extends ContainerUpgradeable {
    private final PartOreDicStorageBus part;
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;
    @GuiSync(value=7)
    public YesNo stickyMode = YesNo.NO;

    public ContainerOreDictStorageBus(InventoryPlayer ip, PartOreDicStorageBus anchor) {
        super(ip, anchor);
        this.part = anchor;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.setReadWriteMode((AccessRestriction)this.part.getConfigManager().getSetting(Settings.ACCESS));
            this.setStorageFilter((StorageFilter)this.part.getConfigManager().getSetting(Settings.STORAGE_FILTER));
            this.setStickyMode((YesNo)this.getUpgradeable().getConfigManager().getSetting(Settings.STICKY_MODE));
        }
        super.standardDetectAndSendChanges();
    }

    @Override
    protected int getHeight() {
        return 170;
    }

    public void partition() {
        MEInventoryHandler<IAEItemStack> cellInv = this.part.getInternalHandler();
        if (cellInv == null) {
            return;
        }
        IntOpenHashSet oreIDs = new IntOpenHashSet();
        for (IAEItemStack itemStack : cellInv.getAvailableItems(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList())) {
            OreReference ref = ((AEItemStack)itemStack).getOre().orElse(null);
            if (ref == null) continue;
            oreIDs.addAll((IntCollection)ref.getOres());
        }
        String oreMatch = "(";
        String append = "";
        IntIterator it = oreIDs.iterator();
        while (it.hasNext()) {
            int oreID = it.nextInt();
            append = it.hasNext() ? ")|(" : ")";
            oreMatch = oreMatch.concat(OreDictionary.getOreName((int)oreID) + append);
        }
        if (oreMatch.equals("(")) {
            oreMatch = "";
        }
        this.part.saveOreMatch(oreMatch);
        this.func_75142_b();
    }

    public void saveOreMatch(String value) {
        this.part.saveOreMatch(value);
    }

    public void sendRegex() {
        try {
            NetworkHandler.instance().sendTo(new PacketValueConfig("OreDictStorageBus.sendRegex", this.part.getOreExp()), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    @Override
    protected void setupConfig() {
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getInventoryPlayer()).setNotDraggable());
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    public YesNo getStickyMode() {
        return this.stickyMode;
    }

    private void setStickyMode(YesNo stickyMode) {
        this.stickyMode = stickyMode;
    }
}

