/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.spatial;

import appeng.block.spatial.BlockSpatialPylon;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.client.render.spatial.SpatialPylonTextureType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

class SpatialPylonBakedModel
implements IBakedModel {
    private final Map<SpatialPylonTextureType, TextureAtlasSprite> textures;
    private final VertexFormat format;

    SpatialPylonBakedModel(VertexFormat format, Map<SpatialPylonTextureType, TextureAtlasSprite> textures) {
        this.textures = ImmutableMap.copyOf(textures);
        this.format = format;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        int flags = this.getFlags(state);
        CubeBuilder builder = new CubeBuilder(this.format);
        if (flags != 0) {
            EnumFacing ori = null;
            int displayAxis = flags & 0xC;
            if (displayAxis == 4) {
                ori = EnumFacing.EAST;
                if ((flags & 3) == 2) {
                    builder.setUvRotation(EnumFacing.SOUTH, 1);
                    builder.setUvRotation(EnumFacing.NORTH, 1);
                    builder.setUvRotation(EnumFacing.UP, 2);
                    builder.setUvRotation(EnumFacing.DOWN, 2);
                } else if ((flags & 3) == 1) {
                    builder.setUvRotation(EnumFacing.SOUTH, 2);
                    builder.setUvRotation(EnumFacing.NORTH, 2);
                    builder.setUvRotation(EnumFacing.UP, 1);
                    builder.setUvRotation(EnumFacing.DOWN, 1);
                } else {
                    builder.setUvRotation(EnumFacing.SOUTH, 1);
                    builder.setUvRotation(EnumFacing.NORTH, 1);
                    builder.setUvRotation(EnumFacing.UP, 1);
                    builder.setUvRotation(EnumFacing.DOWN, 1);
                }
            } else if (displayAxis == 8) {
                ori = EnumFacing.UP;
                if ((flags & 3) == 2) {
                    builder.setUvRotation(EnumFacing.NORTH, 3);
                    builder.setUvRotation(EnumFacing.SOUTH, 3);
                    builder.setUvRotation(EnumFacing.EAST, 3);
                    builder.setUvRotation(EnumFacing.WEST, 3);
                }
            } else if (displayAxis == 12) {
                ori = EnumFacing.NORTH;
                if ((flags & 3) == 2) {
                    builder.setUvRotation(EnumFacing.EAST, 2);
                    builder.setUvRotation(EnumFacing.WEST, 1);
                } else if ((flags & 3) == 1) {
                    builder.setUvRotation(EnumFacing.EAST, 1);
                    builder.setUvRotation(EnumFacing.WEST, 2);
                    builder.setUvRotation(EnumFacing.UP, 3);
                    builder.setUvRotation(EnumFacing.DOWN, 3);
                } else {
                    builder.setUvRotation(EnumFacing.EAST, 1);
                    builder.setUvRotation(EnumFacing.WEST, 2);
                }
            }
            builder.setTextures(this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, EnumFacing.UP)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, EnumFacing.DOWN)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, EnumFacing.NORTH)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, EnumFacing.SOUTH)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, EnumFacing.EAST)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideOutside(flags, ori, EnumFacing.WEST)));
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
            if ((flags & 0x20) == 32) {
                builder.setRenderFullBright(true);
            }
            builder.setTextures(this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, EnumFacing.UP)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, EnumFacing.DOWN)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, EnumFacing.NORTH)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, EnumFacing.SOUTH)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, EnumFacing.EAST)), this.textures.get((Object)SpatialPylonBakedModel.getTextureTypeFromSideInside(flags, ori, EnumFacing.WEST)));
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
        } else {
            builder.setTexture(this.textures.get((Object)SpatialPylonTextureType.BASE));
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
            builder.setTexture(this.textures.get((Object)SpatialPylonTextureType.DIM));
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
        }
        return builder.getOutput();
    }

    private int getFlags(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            return 0;
        }
        IExtendedBlockState extState = (IExtendedBlockState)state;
        return (Integer)extState.getValue((IUnlistedProperty)BlockSpatialPylon.STATE);
    }

    private static SpatialPylonTextureType getTextureTypeFromSideOutside(int flags, EnumFacing ori, EnumFacing dir) {
        if (ori == dir || ori.func_176734_d() == dir) {
            return SpatialPylonTextureType.BASE;
        }
        if ((flags & 3) == 3) {
            return SpatialPylonTextureType.BASE_SPANNED;
        }
        if ((flags & 3) == 1) {
            return SpatialPylonTextureType.BASE_END;
        }
        if ((flags & 3) == 2) {
            return SpatialPylonTextureType.BASE_END;
        }
        return SpatialPylonTextureType.BASE;
    }

    private static SpatialPylonTextureType getTextureTypeFromSideInside(int flags, EnumFacing ori, EnumFacing dir) {
        boolean good;
        boolean bl = good = (flags & 0x10) == 16;
        if (ori == dir || ori.func_176734_d() == dir) {
            return good ? SpatialPylonTextureType.DIM : SpatialPylonTextureType.RED;
        }
        if ((flags & 3) == 3) {
            return good ? SpatialPylonTextureType.DIM_SPANNED : SpatialPylonTextureType.RED_SPANNED;
        }
        if ((flags & 3) == 1) {
            return good ? SpatialPylonTextureType.DIM_END : SpatialPylonTextureType.RED_END;
        }
        if ((flags & 3) == 2) {
            return good ? SpatialPylonTextureType.DIM_END : SpatialPylonTextureType.RED_END;
        }
        return SpatialPylonTextureType.BASE;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.textures.get((Object)SpatialPylonTextureType.DIM);
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

