/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.parts.IPartBakedModel;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.util.Platform;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

public class P2PTunnelFrequencyBakedModel
implements IBakedModel,
IPartBakedModel {
    private final VertexFormat format;
    private final TextureAtlasSprite texture;
    private static final Cache<Long, List<BakedQuad>> modelCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private static final int[][] QUAD_OFFSETS = new int[][]{{4, 10, 2}, {10, 10, 2}, {4, 4, 2}, {10, 4, 2}};

    public P2PTunnelFrequencyBakedModel(VertexFormat format, TextureAtlasSprite texture) {
        this.format = format;
        this.texture = texture;
    }

    @Override
    public List<BakedQuad> getPartQuads(Long partFlags, long rand) {
        try {
            return (List)modelCache.get((Object)partFlags, () -> {
                short frequency = 0;
                boolean active = false;
                if (partFlags != null) {
                    frequency = (short)(partFlags & 0xFFFFL);
                    active = (partFlags & 0x10000L) != 0L;
                }
                return this.getQuadsForFrequency(frequency, active);
            });
        }
        catch (ExecutionException e) {
            return Collections.emptyList();
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        return this.getPartQuads(null, rand);
    }

    private List<BakedQuad> getQuadsForFrequency(short frequency, boolean active) {
        AEColor[] colors = Platform.p2p().toColors(frequency);
        CubeBuilder cb = new CubeBuilder(this.format);
        cb.setTexture(this.texture);
        cb.useStandardUV();
        cb.setRenderFullBright(active);
        for (int i = 0; i < 4; ++i) {
            int[] offs = QUAD_OFFSETS[i];
            for (int j = 0; j < 4; ++j) {
                AEColor c = colors[j];
                if (active) {
                    cb.setColorRGB(c.dye.func_193350_e());
                } else {
                    float[] cv = c.dye.func_193349_f();
                    cb.setColorRGB(cv[0] * 0.5f, cv[1] * 0.5f, cv[2] * 0.5f);
                }
                int startx = j % 2;
                int starty = 1 - j / 2;
                cb.addCube(offs[0] + startx, offs[1] + starty, offs[2], offs[0] + startx + 1, offs[1] + starty + 1, offs[2] + 1);
            }
        }
        return cb.getOutput();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.texture;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

