/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CableBuilder;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeBuilder;
import appeng.core.AELog;
import appeng.core.features.registries.PartModels;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class CableBusModel
implements IModel {
    private final PartModels partModels;

    public CableBusModel(PartModels partModels) {
        this.partModels = partModels;
    }

    public Collection<ResourceLocation> getDependencies() {
        this.partModels.setInitialized(true);
        return this.partModels.getModels();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.builder().addAll(CableBuilder.getTextures()).build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Map<ResourceLocation, IBakedModel> partModels = this.loadPartModels(state, format, bakedTextureGetter);
        CableBuilder cableBuilder = new CableBuilder(format, bakedTextureGetter);
        FacadeBuilder facadeBuilder = new FacadeBuilder();
        TextureAtlasSprite particleTexture = cableBuilder.getCoreTexture(CableCoreType.GLASS, AEColor.TRANSPARENT);
        return new CableBusBakedModel(cableBuilder, facadeBuilder, partModels, particleTexture);
    }

    private Map<ResourceLocation, IBakedModel> loadPartModels(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ResourceLocation location : this.partModels.getModels()) {
            IModel model = this.tryLoadPartModel(location);
            IBakedModel bakedModel = model.bake(state, format, bakedTextureGetter);
            result.put((Object)location, (Object)bakedModel);
        }
        return result.build();
    }

    private IModel tryLoadPartModel(ResourceLocation location) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)location);
        }
        catch (Exception e) {
            AELog.error(e, "Unable to load part model " + location);
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

