/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.me.ItemRepo;
import appeng.client.me.SlotME;
import appeng.container.implementations.ContainerNetworkStatus;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public class GuiNetworkStatus
extends AEBaseGui
implements ISortSource {
    private final ItemRepo repo;
    private final int rows = 4;
    private final ContainerNetworkStatus cns;
    private GuiImgButton units;
    private int tooltip = -1;

    public GuiNetworkStatus(InventoryPlayer inventoryPlayer, INetworkTool te) {
        super(new ContainerNetworkStatus(inventoryPlayer, te));
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new ItemRepo(scrollbar, this);
        this.field_147000_g = 153;
        this.field_146999_f = 195;
        this.repo.setRowSize(5);
        this.cns = (ContainerNetworkStatus)this.field_147002_h;
        this.cns.setGui(this);
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.units) {
            AEConfig.instance().nextPowerUnit(backwards);
            this.units.set(AEConfig.instance().selectedPowerUnit());
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.units = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, Settings.POWER_UNITS, AEConfig.instance().selectedPowerUnit());
        this.field_146292_n.add(this.units);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        this.tooltip = -1;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 14 + x * 31;
            int minY = gy + 41 + y * 18;
            if (minX < mouseX && minX + 28 > mouseX && minY < mouseY && minY + 20 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 4) continue;
            ++y;
            x = 0;
        }
        super.func_73863_a(mouseX, mouseY, btn);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        ContainerNetworkStatus ns = (ContainerNetworkStatus)this.field_147002_h;
        this.field_146289_q.func_78276_b(GuiText.NetworkDetails.getLocal(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.StoredPower.getLocal() + ": " + Platform.formatPowerLong(ns.getCurrentPower(), false), 13, 16, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.MaxPower.getLocal() + ": " + Platform.formatPowerLong(ns.getMaxPower(), false), 13, 26, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.PowerInputRate.getLocal() + ": " + Platform.formatPowerLong(ns.getAverageAddition(), true), 13, 133, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.PowerUsageRate.getLocal() + ": " + Platform.formatPowerLong(ns.getPowerUsage(), true), 13, 123, 0x404040);
        int sectionLength = 30;
        int x = 0;
        int y = 0;
        int xo = 12;
        int yo = 42;
        boolean viewStart = false;
        int viewEnd = 20;
        String toolTip = "";
        int toolPosX = 0;
        int toolPosY = 0;
        for (int z = 0; z < Math.min(20, this.repo.size()); ++z) {
            IAEItemStack refStack = this.repo.getReferenceItem(z);
            if (refStack == null) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            String str = Long.toString(refStack.getStackSize());
            if (refStack.getStackSize() >= 10000L) {
                str = Long.toString(refStack.getStackSize() / 1000L) + 'k';
            }
            int w = this.field_146289_q.func_78256_a(str);
            this.field_146289_q.func_78276_b(str, (int)(((double)(x * 30 + 12 + 30 - 19) - (double)w * 0.5) * 2.0), (y * 18 + 42 + 6) * 2, 0x404040);
            GlStateManager.func_179121_F();
            int posX = x * 30 + 12 + 30 - 18;
            int posY = y * 18 + 42;
            if (this.tooltip == z - 0) {
                toolTip = Platform.getItemDisplayName(refStack);
                toolTip = toolTip + '\n' + GuiText.Installed.getLocal() + ": " + refStack.getStackSize();
                if (refStack.getCountRequestable() > 0L) {
                    toolTip = toolTip + '\n' + GuiText.EnergyDrain.getLocal() + ": " + Platform.formatPowerLong(refStack.getCountRequestable(), true);
                }
                toolPosX = x * 30 + 12 + 30 - 8;
                toolPosY = y * 18 + 42;
            }
            this.drawItem(posX, posY, refStack.asItemStackRepresentation());
            if (++x <= 4) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && toolTip.length() > 0) {
            this.drawTooltip(toolPosX, toolPosY + 10, toolTip);
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/networkstatus.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void postUpdate(List<IAEItemStack> list) {
        this.repo.clear();
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        int size = this.repo.size();
        this.getScrollBar().setTop(39).setLeft(175).setHeight(78);
        this.getScrollBar().setRange(0, (size + 4) / 5 - this.rows, 1);
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        Slot s = this.getSlot(x, y);
        if (s instanceof SlotME && stack != null) {
            IAEItemStack myStack = null;
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable theSlotField) {
                // empty catch block
            }
            if (myStack != null) {
                ITooltipFlag.TooltipFlags tooltipFlag = this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
                List currentToolTip = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)tooltipFlag);
                while (currentToolTip.size() > 1) {
                    currentToolTip.remove(1);
                }
                currentToolTip.add(GuiText.Installed.getLocal() + ": " + myStack.getStackSize());
                currentToolTip.add(GuiText.EnergyDrain.getLocal() + ": " + Platform.formatPowerLong(myStack.getCountRequestable(), true));
                this.drawTooltip(x, y, currentToolTip);
            }
        }
        super.func_146285_a(stack, x, y);
    }

    @Override
    public Enum getSortBy() {
        return SortOrder.NAME;
    }

    @Override
    public Enum getSortDir() {
        return SortDir.ASCENDING;
    }

    @Override
    public Enum getSortDisplay() {
        return ViewItems.ALL;
    }
}

