/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Stack;

public class MathExpressionParser {
    private final Stack<String> postfixStack = new Stack();
    private final Stack<Character> opStack = new Stack();
    private static final int[] OPERATOR_PRIORITY = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static double parse(String expression) {
        double result;
        if (expression == null) {
            return Double.NaN;
        }
        if ((expression = expression.replace(" ", "")).length() == 1 && Character.isDigit(expression.charAt(0))) {
            return expression.charAt(0) - 48;
        }
        try {
            expression = MathExpressionParser.transform(expression);
            result = new MathExpressionParser().calculate(expression);
        }
        catch (Exception e) {
            return Double.NaN;
        }
        return result;
    }

    private static String transform(String expression) {
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != '-') continue;
            if (i == 0) {
                arr[i] = 126;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
            arr[i] = 126;
        }
        if (arr[0] == '~' || arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    public double calculate(String expression) {
        Stack<String> resultStack = new Stack<String>();
        this.prepare(expression);
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentValue = this.postfixStack.pop();
            if (!MathExpressionParser.isOperator(currentValue.charAt(0))) {
                currentValue = currentValue.replace("~", "-");
                resultStack.push(currentValue);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            String tempResult = this.calculate(firstValue, secondValue, currentValue.charAt(0));
            resultStack.push(String.valueOf(tempResult));
        }
        return Double.parseDouble((String)resultStack.pop());
    }

    private void prepare(String expression) {
        this.opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (MathExpressionParser.isOperator(currentOp)) {
                if (count > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count));
                }
                char peekOp = this.opStack.peek().charValue();
                if (currentOp == ')') {
                    while (this.opStack.peek().charValue() != '(') {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                    }
                    this.opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && MathExpressionParser.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        peekOp = this.opStack.peek().charValue();
                    }
                    this.opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count;
        }
        if (count > 1 || count == 1 && !MathExpressionParser.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count));
        }
        while (this.opStack.peek().charValue() != ',') {
            this.postfixStack.push(String.valueOf(this.opStack.pop()));
        }
    }

    private static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')';
    }

    private static boolean compare(char cur, char peek) {
        return OPERATOR_PRIORITY[peek - 40] >= OPERATOR_PRIORITY[cur - 40];
    }

    private String calculate(String firstValue, String secondValue, char currentOp) {
        String string;
        switch (currentOp) {
            case '+': {
                string = MathExpressionParser.add(firstValue, secondValue);
                break;
            }
            case '-': {
                string = MathExpressionParser.sub(firstValue, secondValue);
                break;
            }
            case '*': {
                string = MathExpressionParser.mul(firstValue, secondValue);
                break;
            }
            case '/': {
                string = MathExpressionParser.div(firstValue, secondValue);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String add(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return String.valueOf(b1.add(b2));
    }

    public static String sub(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return String.valueOf(b1.subtract(b2));
    }

    public static String mul(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return String.valueOf(b1.multiply(b2));
    }

    public static String div(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return String.valueOf(b1.divide(b2, 16, RoundingMode.HALF_UP));
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        return b.divide(BigDecimal.ONE, scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static String round(String v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(v);
        return String.valueOf(b.divide(BigDecimal.ONE, scale, RoundingMode.HALF_UP));
    }
}

