/*
 * Decompiled with CFR 0.152.
 */
package appeng.capabilities;

import appeng.api.storage.ISpatialDimension;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.capabilities.NullMENetworkAccessor;
import appeng.capabilities.NullSpatialDimension;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import gregtech.api.capability.IEnergyContainer;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.energy.IEnergyStorage;

public final class Capabilities {
    public static Capability<IStorageMonitorableAccessor> STORAGE_MONITORABLE_ACCESSOR;
    public static Capability<ISpatialDimension> SPATIAL_DIMENSION;
    public static Capability<ITeslaConsumer> TESLA_CONSUMER;
    public static Capability<ITeslaHolder> TESLA_HOLDER;
    public static Capability<IEnergyStorage> FORGE_ENERGY;
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY;
    public static Capability<IEnergyContainer> GTCE_ENERGY;

    private Capabilities() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IStorageMonitorableAccessor.class, Capabilities.createNullStorage(), NullMENetworkAccessor::new);
        CapabilityManager.INSTANCE.register(ISpatialDimension.class, Capabilities.createNullStorage(), NullSpatialDimension::new);
    }

    @CapabilityInject(value=IStorageMonitorableAccessor.class)
    private static void capIStorageMonitorableAccessorRegistered(Capability<IStorageMonitorableAccessor> cap) {
        STORAGE_MONITORABLE_ACCESSOR = cap;
    }

    @CapabilityInject(value=ISpatialDimension.class)
    private static void capISpatialDimensionRegistered(Capability<ISpatialDimension> cap) {
        SPATIAL_DIMENSION = cap;
    }

    @CapabilityInject(value=ITeslaConsumer.class)
    private static void capITeslaConsumerRegistered(Capability<ITeslaConsumer> cap) {
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.TESLA)) {
            TESLA_CONSUMER = cap;
        }
    }

    @CapabilityInject(value=ITeslaHolder.class)
    private static void capITeslaHolderRegistered(Capability<ITeslaHolder> cap) {
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.TESLA)) {
            TESLA_HOLDER = cap;
        }
    }

    @CapabilityInject(value=IEnergyStorage.class)
    private static void capIEnergyStorageRegistered(Capability<IEnergyStorage> cap) {
        FORGE_ENERGY = cap;
    }

    @CapabilityInject(value=IItemRepository.class)
    private static void capIItemRepositoryRegistered(Capability<IItemRepository> cap) {
        ITEM_REPOSITORY_CAPABILITY = cap;
    }

    @CapabilityInject(value=IEnergyContainer.class)
    private static void capIEnergyContainerRegistered(Capability<IEnergyContainer> cap) {
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.GTCE)) {
            GTCE_ENERGY = cap;
        }
    }

    private static <T> Capability.IStorage<T> createNullStorage() {
        return new Capability.IStorage<T>(){

            public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
            }
        };
    }
}

