/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.client.render.effects.LightningFX;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.helpers.ICustomCollision;
import appeng.helpers.MetaRotation;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockQuartzFixture
extends AEBaseBlock
implements IOrientableBlock,
ICustomCollision {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool ODD = PropertyBool.func_177716_a((String)"odd");

    public BlockQuartzFixture() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)ODD, (Comparable)Boolean.valueOf(false)));
        this.func_149715_a(0.9375f);
        this.func_149713_g(0);
        this.setFullSize(false);
        this.setOpaque(false);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean oddPlacement = (pos.func_177958_n() + pos.func_177956_o() + pos.func_177952_p()) % 2 != 0;
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)ODD, (Comparable)Boolean.valueOf(oddPlacement));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.values()[meta];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{FACING, ODD};
    }

    @Override
    public boolean isValidOrientation(World w, BlockPos pos, EnumFacing forward, EnumFacing up) {
        return this.canPlaceAt(w, pos, up.func_176734_d());
    }

    private boolean canPlaceAt(World w, BlockPos pos, EnumFacing dir) {
        BlockPos test = pos.func_177972_a(dir);
        return w.isSideSolid(test, dir.func_176734_d(), false);
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, BlockPos pos, Entity e, boolean isVisual) {
        EnumFacing up = this.getOrientable((IBlockAccess)w, pos).getUp();
        double xOff = -0.3 * (double)up.func_82601_c();
        double yOff = -0.3 * (double)up.func_96559_d();
        double zOff = -0.3 * (double)up.func_82599_e();
        return Collections.singletonList(new AxisAlignedBB(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
    }

    public void addCollidingBlockToList(World w, BlockPos pos, AxisAlignedBB bb, List out, Entity e) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World w, BlockPos pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        if ((double)r.nextFloat() < 0.98) {
            return;
        }
        EnumFacing up = this.getOrientable((IBlockAccess)w, pos).getUp();
        double xOff = -0.3 * (double)up.func_82601_c();
        double yOff = -0.3 * (double)up.func_96559_d();
        double zOff = -0.3 * (double)up.func_82599_e();
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (!AppEng.proxy.shouldAddParticles(r)) continue;
            LightningFX fx = new LightningFX(w, xOff + 0.5 + (double)pos.func_177958_n(), yOff + 0.5 + (double)pos.func_177956_o(), zOff + 0.5 + (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing up = this.getOrientable((IBlockAccess)world, pos).getUp();
        if (!this.canPlaceAt(world, pos, up.func_176734_d())) {
            this.dropTorch(world, pos);
        }
    }

    private void dropTorch(World w, BlockPos pos) {
        IBlockState prev = w.func_180495_p(pos);
        w.func_175655_b(pos, true);
        w.func_184138_a(pos, prev, w.func_180495_p(pos), 3);
    }

    public boolean func_176196_c(World w, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.canPlaceAt(w, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean usesMetadata() {
        return true;
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, BlockPos pos) {
        return new MetaRotation(w, pos, (IProperty<EnumFacing>)FACING);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

