/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.text.translation.I18n;

public enum AEColor {
    WHITE("gui.appliedenergistics2.White", EnumDyeColor.WHITE, 0xBEBEBE, 0xDBDBDB, 0xFAFAFA),
    ORANGE("gui.appliedenergistics2.Orange", EnumDyeColor.ORANGE, 16357177, 16428612, 16047811),
    MAGENTA("gui.appliedenergistics2.Magenta", EnumDyeColor.MAGENTA, 8527490, 12069560, 12949704),
    LIGHT_BLUE("gui.appliedenergistics2.LightBlue", EnumDyeColor.LIGHT_BLUE, 6458827, 8563943, 14219007),
    YELLOW("gui.appliedenergistics2.Yellow", EnumDyeColor.YELLOW, 0xFFF7AA, 16318282, 0xFFFFE8),
    LIME("gui.appliedenergistics2.Lime", EnumDyeColor.LIME, 8191818, 12320593, 15202263),
    PINK("gui.appliedenergistics2.Pink", EnumDyeColor.PINK, 14454197, 16299479, 16244459),
    GRAY("gui.appliedenergistics2.Gray", EnumDyeColor.GRAY, 0x7C7C7C, 0xA0A0A0, 0xC9C9C9),
    LIGHT_GRAY("gui.appliedenergistics2.LightGray", EnumDyeColor.SILVER, 0x9D9D9D, 0xCDCDCD, 0xEFEFEF),
    CYAN("gui.appliedenergistics2.Cyan", EnumDyeColor.CYAN, 3120037, 5352134, 11460084),
    PURPLE("gui.appliedenergistics2.Purple", EnumDyeColor.PURPLE, 8532146, 10769358, 13083596),
    BLUE("gui.appliedenergistics2.Blue", EnumDyeColor.BLUE, 2959776, 5327615, 14542591),
    BROWN("gui.appliedenergistics2.Brown", EnumDyeColor.BROWN, 7491125, 12031615, 14734024),
    GREEN("gui.appliedenergistics2.Green", EnumDyeColor.GREEN, 4562977, 6349614, 14938851),
    RED("gui.appliedenergistics2.Red", EnumDyeColor.RED, 10813481, 16711740, 16770797),
    BLACK("gui.appliedenergistics2.Black", EnumDyeColor.BLACK, 0x2B2B2B, 0x565656, 0x848484),
    TRANSPARENT("gui.appliedenergistics2.Fluix", null, 1778500, 9002152, 14138348);

    public static final List<AEColor> VALID_COLORS;
    public static final int TINTINDEX_DARK = 1;
    public static final int TINTINDEX_MEDIUM = 2;
    public static final int TINTINDEX_BRIGHT = 3;
    public static final int TINTINDEX_MEDIUM_BRIGHT = 4;
    public final String unlocalizedName;
    public final int blackVariant;
    public final int mediumVariant;
    public final int whiteVariant;
    public final EnumDyeColor dye;

    private AEColor(String unlocalizedName, EnumDyeColor dye, int blackHex, int medHex, int whiteHex) {
        this.unlocalizedName = unlocalizedName;
        this.blackVariant = blackHex;
        this.mediumVariant = medHex;
        this.whiteVariant = whiteHex;
        this.dye = dye;
    }

    public int getVariantByTintIndex(int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.blackVariant;
            }
            case 2: {
                return this.mediumVariant;
            }
            case 3: {
                return this.whiteVariant;
            }
            case 4: {
                int light = this.whiteVariant;
                int dark = this.mediumVariant;
                return ((light >> 16 & 0xFF) + (dark >> 16 & 0xFF)) / 2 << 16 | ((light >> 8 & 0xFF) + (dark >> 8 & 0xFF)) / 2 << 8 | ((light & 0xFF) + (dark & 0xFF)) / 2;
            }
        }
        return -1;
    }

    public boolean matches(AEColor color) {
        return this == TRANSPARENT || color == TRANSPARENT || this == color;
    }

    public String toString() {
        return I18n.func_74838_a((String)this.unlocalizedName);
    }

    static {
        VALID_COLORS = Arrays.asList(WHITE, ORANGE, MAGENTA, LIGHT_BLUE, YELLOW, LIME, PINK, GRAY, LIGHT_GRAY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK);
    }
}

