/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IParts;
import appeng.api.parts.IPartItem;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;

public enum TunnelType {
    ME(TunnelType.tryPartStack(IParts::p2PTunnelME)),
    IC2_POWER(TunnelType.tryPartStack(IParts::p2PTunnelEU)),
    FE_POWER(TunnelType.tryPartStack(IParts::p2PTunnelFE)),
    GTEU_POWER(TunnelType.tryPartStack(IParts::p2PTunnelGTEU)),
    REDSTONE(TunnelType.tryPartStack(IParts::p2PTunnelRedstone)),
    FLUID(TunnelType.tryPartStack(IParts::p2PTunnelFE)),
    ITEM(TunnelType.tryPartStack(IParts::p2PTunnelItems)),
    LIGHT(TunnelType.tryPartStack(IParts::p2PTunnelLight));

    private ItemStack partItemStack;
    private Supplier<ItemStack> partItemStackSupplier;

    @Deprecated
    private TunnelType() {
        this.partItemStack = ItemStack.field_190927_a;
        this.partItemStackSupplier = null;
    }

    private TunnelType(ItemStack partItemStack) {
        this.partItemStack = partItemStack;
        this.partItemStackSupplier = null;
    }

    private TunnelType(Supplier<ItemStack> supplier) {
        this.partItemStack = null;
        this.partItemStackSupplier = supplier;
    }

    private static Supplier<ItemStack> tryPartStack(Function<IParts, IItemDefinition> supplier) {
        return () -> ((IItemDefinition)supplier.apply(AEApi.instance().definitions().parts())).maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    public static TunnelType registerTunnelType(@Nonnull String name, @Nonnull ItemStack partItemStack) {
        Preconditions.checkArgument((partItemStack.func_190926_b() || partItemStack.func_77973_b() instanceof IPartItem ? 1 : 0) != 0, (Object)"Part item must be an instance of IPartItem");
        return (TunnelType)EnumHelper.addEnum(TunnelType.class, (String)name, (Class[])new Class[]{ItemStack.class}, (Object[])new Object[]{partItemStack});
    }

    public ItemStack getPartItemStack() {
        if (this.partItemStackSupplier != null) {
            this.partItemStack = this.partItemStackSupplier.get();
            this.partItemStackSupplier = null;
        }
        return this.partItemStack;
    }
}

