/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.config;

import com.enderio.core.EnderCore;
import com.enderio.core.common.config.AbstractConfigHandler;
import com.enderio.core.common.config.PacketConfigSync;
import com.enderio.core.common.config.TypeAdapterBase;
import com.enderio.core.common.config.annot.Comment;
import com.enderio.core.common.config.annot.Config;
import com.enderio.core.common.config.annot.NoSync;
import com.enderio.core.common.config.annot.Range;
import com.enderio.core.common.config.annot.RestartReq;
import com.enderio.core.common.event.ConfigFileChangedEvent;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.util.Bound;
import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.commons.lang3.StringUtils;

public class ConfigProcessor {
    @Nonnull
    static final Map<String, ConfigProcessor> processorMap = Maps.newHashMap();
    @Nonnull
    protected final List<ITypeAdapter<?, ?>> adapters = Lists.newArrayList();
    @Nonnull
    protected final String modid;
    @Nonnull
    protected final Class<?> configs;
    @Nonnull
    protected final Configuration configFile;
    @Nullable
    protected final IReloadCallback callback;
    @Nonnull
    protected Map<String, Object> configValues = Maps.newHashMap();
    @Nonnull
    protected final Map<String, Object> defaultValues = Maps.newHashMap();
    @Nonnull
    protected final Map<String, Object> originalValues = Maps.newHashMap();
    @Nonnull
    protected final Set<String> sections = Sets.newHashSet();

    public ConfigProcessor(@Nonnull Class<?> configs, @Nonnull File configFile, @Nonnull String modid) {
        this(configs, configFile, modid, null);
    }

    public ConfigProcessor(@Nonnull Class<?> configs, @Nonnull File configFile, @Nonnull String modid, @Nullable IReloadCallback callback) {
        this(configs, new Configuration(configFile), modid, callback);
    }

    public ConfigProcessor(@Nonnull Class<?> configs, @Nonnull AbstractConfigHandler handler) {
        this(configs, handler, null);
    }

    public ConfigProcessor(@Nonnull Class<?> configs, @Nonnull AbstractConfigHandler handler, @Nullable IReloadCallback callback) {
        this(configs, handler.getConfig(), handler.modid, callback);
    }

    protected ConfigProcessor(@Nonnull Class<?> configs, @Nonnull Configuration configFile, @Nonnull String modid, @Nullable IReloadCallback callback) {
        this.configs = configs;
        this.configFile = configFile;
        this.modid = modid;
        this.callback = callback;
        processorMap.put(modid, this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.adapters.addAll(TypeAdapterBase.all);
    }

    public <ACTUAL, BASE> ConfigProcessor addAdapter(ITypeAdapter<ACTUAL, BASE> adapter) {
        this.adapters.add(adapter);
        return this;
    }

    @SafeVarargs
    public final <ACTUAL, BASE> ConfigProcessor addAdapters(ITypeAdapter<ACTUAL, BASE> ... adaptersIn) {
        for (ITypeAdapter<ACTUAL, BASE> adapter : adaptersIn) {
            this.addAdapter(adapter);
        }
        return this;
    }

    public void process(boolean load) {
        if (load) {
            this.configFile.load();
        }
        try {
            for (Field f : this.configs.getDeclaredFields()) {
                this.processField(f);
            }
            if (this.callback != null) {
                this.callback.callback(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.configFile.save();
    }

    protected boolean processField(Field f) throws Exception {
        Config cfg = f.getAnnotation(Config.class);
        if (cfg == null) {
            return false;
        }
        String name = f.getName();
        Object value = this.defaultValues.get(name);
        if (value == null) {
            value = NullHelper.notnull(f.get(null), "missing default value");
            this.defaultValues.put(name, value);
        }
        Object newValue = this.getConfigValue(cfg.value(), this.getComment(f), f, value);
        this.configValues.put(f.getName(), newValue);
        this.originalValues.put(f.getName(), newValue);
        f.set(null, newValue);
        this.sections.add(cfg.value());
        return !value.equals(newValue);
    }

    protected Object getConfigValue(@Nonnull String section, @Nonnull String[] commentLines, @Nonnull Field f, @Nonnull Object defaultValue) {
        Property prop = null;
        Object res = null;
        Bound<Double> bound = this.getBound(f);
        ITypeAdapter<?, ?> adapter = this.getAdapterFor(f);
        String comment = StringUtils.join((Object[])commentLines, (String)"\n");
        if (adapter != null) {
            Object defVal = adapter.createBaseType(defaultValue);
            switch (adapter.getType()) {
                case BOOLEAN: {
                    if (defVal.getClass().isArray()) {
                        prop = this.configFile.get(section, f.getName(), (boolean[])defVal, comment);
                        res = prop.getBooleanList();
                        break;
                    }
                    prop = this.configFile.get(section, f.getName(), ((Boolean)defVal).booleanValue(), comment);
                    res = prop.getBoolean();
                    break;
                }
                case DOUBLE: {
                    if (defVal.getClass().isArray()) {
                        prop = this.configFile.get(section, f.getName(), (double[])defVal, comment);
                        res = AbstractConfigHandler.boundDoubleArr(prop, Bound.of(Double.valueOf((Double)bound.min), Double.valueOf((Double)bound.max)));
                        break;
                    }
                    prop = this.configFile.get(section, f.getName(), ((Double)defVal).doubleValue(), comment);
                    res = AbstractConfigHandler.boundValue(prop, Bound.of(Double.valueOf((Double)bound.min), Double.valueOf((Double)bound.max)), (Double)defVal);
                    break;
                }
                case INTEGER: {
                    if (defVal.getClass().isArray()) {
                        prop = this.configFile.get(section, f.getName(), (int[])defVal, comment);
                        res = AbstractConfigHandler.boundIntArr(prop, Bound.of(((Double)bound.min).intValue(), ((Double)bound.max).intValue()));
                        break;
                    }
                    prop = this.configFile.get(section, f.getName(), ((Integer)defVal).intValue(), comment);
                    res = AbstractConfigHandler.boundValue(prop, Bound.of(((Double)bound.min).intValue(), ((Double)bound.max).intValue()), (Integer)defVal);
                    break;
                }
                case STRING: {
                    if (defVal.getClass().isArray()) {
                        prop = this.configFile.get(section, f.getName(), (String[])defVal, comment);
                        res = prop.getStringList();
                        break;
                    }
                    prop = this.configFile.get(section, f.getName(), (String)defVal, comment);
                    res = prop.getString();
                    break;
                }
            }
            if (res != null) {
                AbstractConfigHandler.setBounds(prop, bound);
                AbstractConfigHandler.addCommentDetails(prop, bound);
                this.getRestartReq(f).apply(prop);
                return adapter.createActualType(res);
            }
        }
        throw new IllegalArgumentException(String.format("No adapter for type %s in class %s, field %s", f.getGenericType(), this.configs, f));
    }

    protected ITypeAdapter<?, ?> getAdapterFor(@Nonnull Field f) {
        TypeToken t = TypeToken.of((Type)f.getGenericType());
        Class<?> c = f.getType();
        for (ITypeAdapter<?, ?> adapter : this.adapters) {
            if ((!c.isPrimitive() || c != adapter.getPrimitiveType()) && !adapter.getActualType().isSupertypeOf(t)) continue;
            return adapter;
        }
        return null;
    }

    public ImmutableSet<String> sections() {
        return ImmutableSet.copyOf(this.sections);
    }

    public ConfigCategory getCategory(String category) {
        return this.configFile.getCategory(category);
    }

    public void syncTo(@Nonnull Map<String, Object> values) {
        this.configValues = values;
        for (String s : this.configValues.keySet()) {
            try {
                Field f = this.configs.getDeclaredField(s);
                Config annot = f.getAnnotation(Config.class);
                if (annot != null && !this.getNoSync(f)) {
                    Object newVal = this.configValues.get(s);
                    Object oldVal = f.get(null);
                    boolean changed = false;
                    if (!oldVal.equals(newVal)) {
                        EnderCore.logger.debug("Config {}.{} differs from new data. Changing from {} to {}", (Object)this.configs.getName(), (Object)f.getName(), oldVal, newVal);
                        f.set(null, newVal);
                        changed = true;
                    }
                    if (!changed || this.callback == null) continue;
                    this.callback.callback(this);
                    continue;
                }
                if (annot == null) continue;
                EnderCore.logger.debug("Skipping syncing field {}.{} as it was marked NoSync", (Object)this.configs.getName(), (Object)f.getName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nonnull
    protected String[] getComment(Field f) {
        Comment c = f.getAnnotation(Comment.class);
        return (String[])NullHelper.first(c == null ? null : c.value(), new String[0]);
    }

    protected Bound<Double> getBound(Field f) {
        Range r = f.getAnnotation(Range.class);
        return r == null ? Bound.MAX_BOUND : Bound.of(r.min(), r.max());
    }

    protected boolean getNoSync(Field f) {
        return f.getAnnotation(NoSync.class) != null;
    }

    protected AbstractConfigHandler.RestartReqs getRestartReq(Field f) {
        RestartReq r = f.getAnnotation(RestartReq.class);
        return r == null ? AbstractConfigHandler.RestartReqs.NONE : r.value();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EnderCore.logger.info("Sending server configs to client for {}", (Object)this.configs.getName());
        EnderPacketHandler.INSTANCE.sendTo(new PacketConfigSync(this), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onPlayerLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.syncTo(this.originalValues);
        EnderCore.logger.info("Reset configs to client values for {}", (Object)this.configs.getName());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(this.modid)) {
            this.process(false);
        }
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.getModID().equals(this.modid)) {
            this.process(true);
        }
    }

    public static interface ITypeAdapter<ACTUAL, BASE> {
        public TypeToken<ACTUAL> getActualType();

        public Property.Type getType();

        @Nullable
        public Class<?> getPrimitiveType();

        public ACTUAL createActualType(BASE var1);

        @Nonnull
        public BASE createBaseType(@Nonnull ACTUAL var1);
    }

    public static interface IReloadCallback {
        public void callback(@Nonnull ConfigProcessor var1);
    }
}

