/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.tile;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.auxiliary.link.ILinkableTile;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleIndependentSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionSourceNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.tile.base.TileSourceBase;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.tiles.base.ColorableMachineTile;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentStarlightProviderOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class TileStarlightOutput
extends TileSourceBase
implements MachineComponentTile,
IStarlightSource,
ILinkableTile,
ColorableMachineTile {
    public int tick;
    public IWeakConstellation constellation = (IWeakConstellation)ConstellationRegistry.getWeakConstellations().get(0);
    private float starlightProduced = 0.0f;
    private int color = Config.machineColor;

    @Override
    public int getMachineColor() {
        return this.color;
    }

    @Override
    public void setMachineColor(int newColor) {
        if (this.color == newColor) {
            return;
        }
        this.color = newColor;
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> ((TileStarlightOutput)this).markForUpdate());
    }

    public float getStarlightProduced() {
        return this.starlightProduced;
    }

    public void setStarlightProduced(float starlightProduced) {
        this.tick = 2;
        this.starlightProduced = starlightProduced;
    }

    @Override
    @Nullable
    public MachineComponentStarlightProviderOutput provideComponent() {
        return new MachineComponentStarlightProviderOutput(this, IOType.OUTPUT);
    }

    public void func_73660_a() {
        if (this.tick > 0) {
            --this.tick;
        } else if (this.starlightProduced > 0.0f) {
            this.starlightProduced = 0.0f;
        }
        super.func_73660_a();
    }

    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blockstarlightprovideroutput.name";
    }

    @Nonnull
    public IIndependentStarlightSource provideNewSourceNode() {
        return new IndependantStarlightProviderSource(this.constellation, this);
    }

    @Nonnull
    public ITransmissionSource provideSourceNode(BlockPos at) {
        return new SimpleTransmissionSourceNode(at);
    }

    public boolean onSelect(EntityPlayer player) {
        if (player.func_70093_af()) {
            for (BlockPos linkTo : Lists.newArrayList((Iterable)this.getLinkedPositions())) {
                this.tryUnlink(player, linkTo);
            }
            player.func_145747_a(new TextComponentTranslation("misc.link.unlink.all", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            return false;
        }
        return true;
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("casingColor", this.color);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.color = compound.func_74762_e("casingColor");
    }

    public static class IndependantStarlightProviderSource
    extends SimpleIndependentSource {
        private final TileStarlightOutput provider;

        public IndependantStarlightProviderSource(IWeakConstellation constellation, TileStarlightOutput provider) {
            super(constellation);
            this.provider = provider;
        }

        public float produceStarlightTick(World world, BlockPos pos) {
            float f;
            if (this.provider != null) {
                return this.provider.getStarlightProduced();
            }
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileStarlightOutput) {
                TileStarlightOutput starlightOutput = (TileStarlightOutput)te;
                f = starlightOutput.getStarlightProduced();
            } else {
                f = 0.0f;
            }
            return f;
        }

        public void informTileStateChange(IStarlightSource sourceTile) {
        }

        public void threadedUpdateProximity(BlockPos thisPos, Map<BlockPos, IIndependentStarlightSource> otherSources) {
        }

        public SourceClassRegistry.SourceProvider getProvider() {
            return new Provider();
        }
    }

    public static class Provider
    implements SourceClassRegistry.SourceProvider {
        public IIndependentStarlightSource provideEmptySource() {
            return new IndependantStarlightProviderSource(null, null);
        }

        public String getIdentifier() {
            return "modularmachinery:IndependantStarlightProviderSource";
        }
    }
}

