/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.tile;

import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.item.ItemBindableBase;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileInventory;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentLifeEssenceProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileLifeEssenceProvider
extends TileInventory
implements MachineComponentTile {
    protected volatile int lifeEssenceCache = 0;

    public TileLifeEssenceProvider() {
        super(1);
    }

    public SoulNetwork getSoulNetwork() {
        ItemBindableBase bloodOrb;
        Binding binding;
        Item item;
        ItemStack stack = this.getInventory().getStackInSlot(0);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ItemBindableBase && (binding = (bloodOrb = (ItemBindableBase)item).getBinding(stack)) != null) {
            return NetworkHelper.getSoulNetwork((Binding)binding);
        }
        return null;
    }

    public int getOrbCapacity() {
        ItemStack stack = this.getInventory().getStackInSlot(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IBloodOrb) {
            BloodOrb orb = ((IBloodOrb)stack.func_77973_b()).getOrb(stack);
            return orb == null ? Integer.MIN_VALUE : orb.getCapacity();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public IOInventory buildInventory(TileInventory tile, int size) {
        return new IOInventory(tile, new int[1], new int[1]){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof IBloodOrb;
            }
        };
    }

    public int getLifeEssenceCache() {
        return this.lifeEssenceCache;
    }

    public abstract int addLifeEssenceCache(int var1);

    public abstract int removeLifeEssenceCache(int var1);

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.lifeEssenceCache = compound.func_74762_e("lifeEssenceCache");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("lifeEssenceCache", this.lifeEssenceCache);
    }

    public static class Output
    extends TileLifeEssenceProvider {
        @Override
        public synchronized void doRestrictedTick() {
            SoulNetwork soulNetwork = this.getSoulNetwork();
            if (soulNetwork == null) {
                return;
            }
            int prev = this.lifeEssenceCache;
            this.lifeEssenceCache -= soulNetwork.add(new SoulTicket(this.lifeEssenceCache), this.getOrbCapacity());
            if (prev != this.lifeEssenceCache) {
                this.markNoUpdate();
            }
        }

        @Override
        public synchronized int addLifeEssenceCache(int amount) {
            int orbCapacity = this.getOrbCapacity();
            if (orbCapacity <= 0) {
                return 0;
            }
            int maxCanAdd = orbCapacity - this.lifeEssenceCache;
            if (maxCanAdd <= 0) {
                return 0;
            }
            int added = Math.min(amount, maxCanAdd);
            this.lifeEssenceCache += added;
            this.markNoUpdateSync();
            return added;
        }

        @Override
        public int removeLifeEssenceCache(int amount) {
            return 0;
        }

        @Override
        @Nullable
        public MachineComponentLifeEssenceProvider provideComponent() {
            return new MachineComponentLifeEssenceProvider(this, IOType.OUTPUT);
        }
    }

    public static class Input
    extends TileLifeEssenceProvider {
        @Override
        public synchronized void doRestrictedTick() {
            SoulNetwork soulNetwork = this.getSoulNetwork();
            if (soulNetwork == null) {
                return;
            }
            int orbCapacity = this.getOrbCapacity();
            if (orbCapacity <= 0) {
                return;
            }
            int maxCapacity = orbCapacity / 10;
            if (this.lifeEssenceCache >= maxCapacity) {
                return;
            }
            int prev = this.lifeEssenceCache;
            this.lifeEssenceCache += soulNetwork.syphon(new SoulTicket(Math.min(maxCapacity - this.lifeEssenceCache, soulNetwork.getCurrentEssence())));
            if (prev != this.lifeEssenceCache) {
                this.markNoUpdate();
            }
        }

        @Override
        public int addLifeEssenceCache(int amount) {
            return 0;
        }

        @Override
        public synchronized int removeLifeEssenceCache(int amount) {
            int maxCanConsume = Math.min(this.lifeEssenceCache, amount);
            this.lifeEssenceCache -= maxCanConsume;
            this.markNoUpdateSync();
            return maxCanConsume;
        }

        @Override
        @Nullable
        public MachineComponentLifeEssenceProvider provideComponent() {
            return new MachineComponentLifeEssenceProvider(this, IOType.INPUT);
        }
    }
}

