/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.tile;

import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentImpetus;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import thaumcraft.api.aspects.Aspect;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusProvider;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.ImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.SimpleImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public abstract class TileImpetusComponent
extends TileColorableMachineComponent
implements MachineComponentTile {
    public static final int CAPACITY = 1000;
    protected volatile int impetus = 0;
    protected ImpetusNode node;

    public int getImpetus() {
        return this.impetus;
    }

    public synchronized int consumeImpetus(int amount) {
        int maxConsume = Math.min(this.impetus, amount);
        this.impetus -= maxConsume;
        return maxConsume;
    }

    public synchronized int supplyImpetus(int amount) {
        int maxSupply = Math.min(1000 - this.impetus, amount);
        this.impetus += maxSupply;
        return maxSupply;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.impetus = compound.func_74762_e("impetus");
        this.node.deserializeNBT(compound.func_74775_l("node"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("impetus", this.impetus);
        compound.func_74782_a("node", (NBTBase)this.node.serializeNBT());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.node);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode((IImpetusNode)this.node);
        }
        this.node.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode((IImpetusNode)this.node);
        super.func_145843_s();
    }

    public void func_145834_a(@Nonnull World worldIn) {
        super.func_145834_a(worldIn);
        this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), worldIn.field_73011_w.getDimension()));
    }

    public void func_174878_a(@Nonnull BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.node.setLocation(new DimensionalBlockPos(posIn.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void onLoad() {
        this.node.init(this.field_145850_b);
        ThaumicAugmentation.proxy.registerRenderableImpetusNode((IImpetusNode)this.node);
    }

    public boolean func_145842_c(int id, int type) {
        ThaumicAugmentation.proxy.getRenderHelper().renderSpark(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat()), 1.5f, Aspect.ELDRITCH.getColor(), false);
        return true;
    }

    public boolean shouldRefresh(@Nonnull World world, @Nonnull BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public static class Output
    extends TileImpetusComponent {
        public Output() {
            this.node = new CustomImpetusProvider(0, 2);
        }

        @Override
        @Nullable
        public MachineComponent<?> provideComponent() {
            return new MachineComponentImpetus(IOType.OUTPUT, this);
        }

        private class CustomImpetusProvider
        extends ImpetusNode
        implements IImpetusProvider {
            private CustomImpetusProvider(int totalInputs, int totalOutputs) {
                super(totalInputs, totalOutputs);
            }

            public synchronized long provide(long energy, boolean simulate) {
                long amount = Math.min((long)Output.this.impetus, energy);
                if (!simulate) {
                    Output.this.impetus -= (int)amount;
                    Output.this.markNoUpdateSync();
                }
                return amount;
            }

            public Vec3d getBeamEndpoint() {
                return new Vec3d((Vec3i)Output.this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
            }
        }
    }

    public static class Input
    extends TileImpetusComponent
    implements ITickable {
        public Input() {
            this.node = new SimpleImpetusConsumer(1, 0){

                public Vec3d getBeamEndpoint() {
                    return new Vec3d((Vec3i)field_174879_c).func_72441_c(0.5, 0.5, 0.5);
                }
            };
        }

        public synchronized void func_73660_a() {
            if (this.field_145850_b.field_72995_K || this.impetus >= 1000) {
                return;
            }
            ConsumeResult result = ((IImpetusConsumer)this.node).consume((long)(1000 - this.impetus), false);
            if (result.energyConsumed > 0L) {
                this.impetus += (int)result.energyConsumed;
                this.markNoUpdate();
            }
        }

        @Override
        @Nullable
        public MachineComponent<?> provideComponent() {
            return new MachineComponentImpetus(IOType.INPUT, this);
        }
    }
}

