/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.requirement;

import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import java.util.List;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.component.ComponentRainbow;
import kport.modularmagic.common.crafting.requirement.types.ModularMagicRequirements;
import kport.modularmagic.common.crafting.requirement.types.RequirementTypeRainbow;
import kport.modularmagic.common.integration.jei.component.JEIComponentRainbow;
import kport.modularmagic.common.integration.jei.ingredient.Rainbow;
import kport.modularmagic.common.tile.TileRainbowProvider;

public class RequirementRainbow
extends ComponentRequirement.PerTickMultiComponent<Rainbow, RequirementTypeRainbow>
implements Asyncable {
    public RequirementRainbow() {
        super((RequirementTypeRainbow)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(ModularMagicRequirements.KEY_REQUIREMENT_RAINBOW), IOType.INPUT);
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cpn = component.getComponent();
        return cpn.getContainerProvider() instanceof TileRainbowProvider && cpn.getComponentType() instanceof ComponentRainbow && cpn.ioType == this.getActionType();
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        return components;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        for (ProcessingComponent<?> component : components) {
            TileRainbowProvider provider = (TileRainbowProvider)component.getComponent().getContainerProvider();
            if (!provider.rainbow()) continue;
            return CraftCheck.success();
        }
        return CraftCheck.failure("error.modularmachinery.requirement.rainbow.less");
    }

    @Override
    public CraftCheck doIOTick(List<ProcessingComponent<?>> components, RecipeCraftingContext context, float durationMultiplier) {
        return this.canStartCrafting(components, context);
    }

    @Override
    public ComponentRequirement<Rainbow, RequirementTypeRainbow> deepCopy() {
        return new RequirementRainbow();
    }

    @Override
    public ComponentRequirement<Rainbow, RequirementTypeRainbow> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementRainbow();
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "error.modularmachinery.component.invalid";
    }

    @Override
    public ComponentRequirement.JEIComponent<Rainbow> provideJEIComponent() {
        return new JEIComponentRainbow();
    }
}

