/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.component.ComponentMana;
import kport.modularmagic.common.crafting.helper.ManaProviderCopy;
import kport.modularmagic.common.crafting.requirement.types.ModularMagicRequirements;
import kport.modularmagic.common.crafting.requirement.types.RequirementTypeMana;
import kport.modularmagic.common.integration.jei.component.JEIComponentMana;
import kport.modularmagic.common.integration.jei.ingredient.Mana;
import kport.modularmagic.common.tile.TileManaProvider;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentManaProvider;

public class RequirementMana
extends ComponentRequirement.PerTickParallelizable<Mana, RequirementTypeMana>
implements Asyncable {
    public int manaAmount;
    public boolean perTick;

    public RequirementMana(IOType actionType, int manaAmount, boolean perTick) {
        super((RequirementTypeMana)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(ModularMagicRequirements.KEY_REQUIREMENT_MANA), actionType);
        this.manaAmount = manaAmount;
        this.perTick = perTick;
    }

    @Nonnull
    private static List<ManaProviderCopy> convertManaProviders(List<ProcessingComponent<?>> components) {
        if (components.size() == 1) {
            return Collections.singletonList((ManaProviderCopy)components.get(0).getProvidedComponent());
        }
        return Lists.transform(components, component -> component != null ? (ManaProviderCopy)component.getProvidedComponent() : null);
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType() instanceof ComponentMana && cmp instanceof MachineComponentManaProvider && cmp.ioType == this.getActionType();
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            list.add(new ProcessingComponent<ManaProviderCopy>(component.component(), new ManaProviderCopy(((ManaProviderCopy)component.providedComponent()).getOriginal()), component.tag()));
        }
        return list;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        switch (this.getActionType()) {
            case INPUT: {
                int taken = this.reduceAll(RequirementMana.convertManaProviders(components), context, this.parallelism, true);
                if (taken >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.mana.less");
            }
            case OUTPUT: {
                int added;
                if (this.ignoreOutputCheck || (added = this.receiveAll(RequirementMana.convertManaProviders(components), context, this.parallelism, true)) >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.mana.space");
            }
        }
        return CraftCheck.success();
    }

    @Override
    public CraftCheck doIOTick(List<ProcessingComponent<?>> components, RecipeCraftingContext context, float durationMultiplier) {
        if (!this.perTick) {
            return CraftCheck.success();
        }
        switch (this.getActionType()) {
            case INPUT: {
                int taken = this.reduceAll(RequirementMana.convertManaProviders(components), context, this.parallelism, false);
                if (taken >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.mana.less");
            }
            case OUTPUT: {
                int added = this.receiveAll(RequirementMana.convertManaProviders(components), context, this.parallelism, false);
                if (added >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.mana.space");
            }
        }
        return CraftCheck.success();
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (!this.perTick && this.getActionType() == IOType.INPUT) {
            this.reduceAll(RequirementMana.convertManaProviders(components), context, this.parallelism, false);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (!this.perTick && this.getActionType() == IOType.OUTPUT) {
            this.receiveAll(RequirementMana.convertManaProviders(components), context, this.parallelism, false);
        }
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        int n;
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            int max;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    int n2 = this.reduceAll(RequirementMana.convertManaProviders(components), context, 1.0f, true);
                    break;
                }
                case OUTPUT: {
                    int n2 = max = this.receiveAll(RequirementMana.convertManaProviders(components), context, 1.0f, true);
                }
            }
            if (max >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INPUT: {
                n = this.reduceAll(RequirementMana.convertManaProviders(components), context, maxParallelism, true);
                break;
            }
            case OUTPUT: {
                n = this.receiveAll(RequirementMana.convertManaProviders(components), context, maxParallelism, true);
            }
        }
        return n;
    }

    private int receiveAll(List<ManaProviderCopy> manaProviderCopies, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toReceive = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.manaAmount, false));
        int maxReceive = (int)((float)toReceive * maxMultiplier);
        int totalReceived = 0;
        for (ManaProviderCopy manaProviderCopy : manaProviderCopies) {
            int capacity = manaProviderCopy.getManaCapacity();
            if (simulate) {
                int maxCanReceive = Math.min(maxReceive - totalReceived, capacity - manaProviderCopy.getCurrentMana());
                if (maxCanReceive > 0) {
                    manaProviderCopy.recieveMana(maxCanReceive);
                    totalReceived += maxCanReceive;
                }
            } else {
                TileManaProvider original = manaProviderCopy.getOriginal();
                int maxCanReceive = Math.min(maxReceive - totalReceived, capacity - original.getCurrentMana());
                if (maxCanReceive > 0) {
                    original.recieveMana(maxCanReceive);
                    totalReceived += maxCanReceive;
                }
            }
            if (totalReceived < maxReceive) continue;
            break;
        }
        if (totalReceived < maxReceive) {
            return totalReceived / toReceive;
        }
        return totalReceived;
    }

    private int reduceAll(List<ManaProviderCopy> manaProviderCopies, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toReduce = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.manaAmount, false));
        int maxReduce = (int)((float)toReduce * maxMultiplier);
        int totalReduced = 0;
        for (ManaProviderCopy manaProviderCopy : manaProviderCopies) {
            if (simulate) {
                int current = manaProviderCopy.getCurrentMana();
                if (current > 0) {
                    int maxCanReduce = Math.min(maxReduce - totalReduced, current);
                    manaProviderCopy.reduceMana(maxCanReduce);
                    totalReduced += maxCanReduce;
                }
            } else {
                TileManaProvider original = manaProviderCopy.getOriginal();
                int current = original.getCurrentMana();
                if (current > 0) {
                    int maxCanReduce = Math.min(maxReduce - totalReduced, current);
                    original.reduceMana(maxCanReduce);
                    totalReduced += maxCanReduce;
                }
            }
            if (totalReduced < maxReduce) continue;
            break;
        }
        if (totalReduced < maxReduce) {
            return totalReduced / toReduce;
        }
        return totalReduced;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "error.modularmachinery.component.invalid";
    }

    public RequirementMana deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementMana deepCopyModified(List<RecipeModifier> list) {
        int manaAmount = Math.round(RecipeModifier.applyModifiers(list, this, (float)this.manaAmount, false));
        return new RequirementMana(this.actionType, manaAmount, this.perTick);
    }

    public JEIComponentMana provideJEIComponent() {
        return new JEIComponentMana(this);
    }
}

