/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.component.ComponentLifeEssence;
import kport.modularmagic.common.crafting.helper.LifeEssenceProviderCopy;
import kport.modularmagic.common.crafting.requirement.types.ModularMagicRequirements;
import kport.modularmagic.common.crafting.requirement.types.RequirementTypeLifeEssence;
import kport.modularmagic.common.integration.jei.component.JEIComponentLifeEssence;
import kport.modularmagic.common.integration.jei.ingredient.LifeEssence;
import kport.modularmagic.common.tile.TileLifeEssenceProvider;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentLifeEssenceProvider;

public class RequirementLifeEssence
extends ComponentRequirement.PerTickParallelizable<LifeEssence, RequirementTypeLifeEssence> {
    public int essenceAmount;
    public boolean perTick;

    public RequirementLifeEssence(IOType actionType, int essenceAmount, boolean perTick) {
        super((RequirementTypeLifeEssence)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(ModularMagicRequirements.KEY_REQUIREMENT_LIFE_ESSENCE), actionType);
        this.essenceAmount = essenceAmount;
        this.perTick = perTick;
    }

    @Nonnull
    private static List<LifeEssenceProviderCopy> convertLifeEssenceProviders(List<ProcessingComponent<?>> components) {
        if (components.size() == 1) {
            return Collections.singletonList((LifeEssenceProviderCopy)components.get(0).getProvidedComponent());
        }
        return Lists.transform(components, component -> component != null ? (LifeEssenceProviderCopy)component.getProvidedComponent() : null);
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType() instanceof ComponentLifeEssence && cmp instanceof MachineComponentLifeEssenceProvider && cmp.ioType == this.getActionType();
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            list.add(new ProcessingComponent<LifeEssenceProviderCopy>(component.component(), new LifeEssenceProviderCopy(((LifeEssenceProviderCopy)component.providedComponent()).getOriginal()), component.tag()));
        }
        return list;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        switch (this.getActionType()) {
            case INPUT: {
                int taken = this.removeAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, this.parallelism, true);
                if (taken >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.lifeessence.lp.less");
            }
            case OUTPUT: {
                int added;
                if (this.ignoreOutputCheck || (added = this.addAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, this.parallelism, true)) >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.lifeessence.lp.more");
            }
        }
        return CraftCheck.success();
    }

    @Override
    public CraftCheck doIOTick(List<ProcessingComponent<?>> components, RecipeCraftingContext context, float durationMultiplier) {
        if (!this.perTick) {
            return CraftCheck.success();
        }
        switch (this.getActionType()) {
            case INPUT: {
                int taken = this.removeAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, this.parallelism, false);
                if (taken >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.lifeessence.lp.less");
            }
            case OUTPUT: {
                int added = this.addAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, this.parallelism, false);
                if (added >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.lifeessence.lp.more");
            }
        }
        return CraftCheck.success();
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (!this.perTick && this.actionType == IOType.INPUT) {
            this.removeAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, this.parallelism, false);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (!this.perTick && this.actionType == IOType.INPUT) {
            this.addAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, this.parallelism, false);
        }
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        int n;
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            int max;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    int n2 = this.removeAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, 1.0f, true);
                    break;
                }
                case OUTPUT: {
                    int n2 = max = this.addAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, 1.0f, true);
                }
            }
            if (max >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INPUT: {
                n = this.removeAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, maxParallelism, true);
                break;
            }
            case OUTPUT: {
                n = this.addAll(RequirementLifeEssence.convertLifeEssenceProviders(components), context, maxParallelism, true);
            }
        }
        return n;
    }

    private int addAll(List<LifeEssenceProviderCopy> lifeEssenceCopies, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toAdd = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.essenceAmount, false));
        int maxAdd = (int)((float)toAdd * maxMultiplier);
        int totalAdded = 0;
        for (LifeEssenceProviderCopy lifeEssenceProviderCopy : lifeEssenceCopies) {
            if (simulate) {
                int lifeEssenceCache = lifeEssenceProviderCopy.getLifeEssenceCache();
                int orbCapacity = lifeEssenceProviderCopy.getOrbCapacity();
                if (orbCapacity <= 0) continue;
                int maxCanAdd = orbCapacity / 10 - lifeEssenceCache;
                totalAdded += lifeEssenceProviderCopy.addLifeEssenceCache(Math.min(maxAdd - totalAdded, maxCanAdd));
            } else {
                TileLifeEssenceProvider original = lifeEssenceProviderCopy.getOriginal();
                int lifeEssenceCache = original.getLifeEssenceCache();
                int orbCapacity = original.getOrbCapacity();
                if (orbCapacity <= 0) continue;
                int maxCanAdd = orbCapacity / 10 - lifeEssenceCache;
                totalAdded += original.addLifeEssenceCache(Math.min(maxAdd - totalAdded, maxCanAdd));
            }
            if (totalAdded < maxAdd) continue;
            break;
        }
        if (totalAdded < maxAdd) {
            return totalAdded / toAdd;
        }
        return totalAdded;
    }

    private int removeAll(List<LifeEssenceProviderCopy> lifeEssenceCopies, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toRemove = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.essenceAmount, false));
        int maxRemove = (int)((float)toRemove * maxMultiplier);
        int totalRemoved = 0;
        for (LifeEssenceProviderCopy lifeEssenceProviderCopy : lifeEssenceCopies) {
            if (simulate) {
                int impetus = lifeEssenceProviderCopy.getLifeEssenceCache();
                totalRemoved += lifeEssenceProviderCopy.removeLifeEssenceCache(Math.min(impetus, maxRemove - totalRemoved));
            } else {
                TileLifeEssenceProvider original = lifeEssenceProviderCopy.getOriginal();
                int impetus = original.getLifeEssenceCache();
                totalRemoved += original.removeLifeEssenceCache(Math.min(impetus, maxRemove - totalRemoved));
            }
            if (totalRemoved < maxRemove) continue;
            break;
        }
        if (totalRemoved < maxRemove) {
            return totalRemoved / toRemove;
        }
        return totalRemoved;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "error.modularmachinery.component.invalid";
    }

    public RequirementLifeEssence deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementLifeEssence deepCopyModified(List<RecipeModifier> list) {
        int essenceAmount = Math.round(RecipeModifier.applyModifiers(list, this, (float)this.essenceAmount, false));
        return new RequirementLifeEssence(this.actionType, essenceAmount, this.perTick);
    }

    public JEIComponentLifeEssence provideJEIComponent() {
        return new JEIComponentLifeEssence(this);
    }
}

