/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.requirement;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.component.ComponentConstellation;
import kport.modularmagic.common.crafting.requirement.types.ModularMagicRequirements;
import kport.modularmagic.common.crafting.requirement.types.RequirementTypeConstellation;
import kport.modularmagic.common.integration.jei.component.JEIComponentConstellation;
import kport.modularmagic.common.integration.jei.ingredient.Constellation;
import kport.modularmagic.common.tile.TileConstellationProvider;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentConstellationProvider;

public class RequirementConstellation
extends ComponentRequirement.MultiComponentRequirement<Constellation, RequirementTypeConstellation>
implements Asyncable {
    public IConstellation constellation;

    public RequirementConstellation(IOType actionType, IConstellation constellation) {
        super((RequirementTypeConstellation)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(ModularMagicRequirements.KEY_REQUIREMENT_CONSTELLATION), actionType);
        this.constellation = constellation;
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType() instanceof ComponentConstellation && cmp instanceof MachineComponentConstellationProvider && cmp.ioType == this.getActionType();
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        return components;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        if (this.getActionType() == IOType.OUTPUT) {
            return CraftCheck.failure("error.modularmachinery.requirement.invalid");
        }
        for (ProcessingComponent<?> component : components) {
            TileConstellationProvider provider = (TileConstellationProvider)component.getComponent().getContainerProvider();
            if (!provider.isConstellationInSky(this.constellation)) continue;
            return CraftCheck.success();
        }
        return CraftCheck.failure("error.modularmachinery.requirement.constellation.less");
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "error.modularmachinery.requirement.constellation.missingprovider";
    }

    public RequirementConstellation deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementConstellation deepCopyModified(List<RecipeModifier> list) {
        return new RequirementConstellation(this.actionType, this.constellation);
    }

    public JEIComponentConstellation provideJEIComponent() {
        return new JEIComponentConstellation(this);
    }
}

