/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.component.ComponentAspect;
import kport.modularmagic.common.crafting.helper.AspectProviderCopy;
import kport.modularmagic.common.crafting.requirement.types.ModularMagicRequirements;
import kport.modularmagic.common.crafting.requirement.types.RequirementTypeAspect;
import kport.modularmagic.common.integration.jei.component.JEIComponentAspect;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentAspectProvider;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.tiles.essentia.TileJarFillable;

public class RequirementAspect
extends ComponentRequirement.MultiCompParallelizable<AspectList, RequirementTypeAspect>
implements Asyncable,
ComponentRequirement.Parallelizable {
    public int amount;
    public Aspect aspect;

    public RequirementAspect(IOType actionType, int amount, Aspect aspect) {
        super((RequirementTypeAspect)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(ModularMagicRequirements.KEY_REQUIREMENT_ASPECT), actionType);
        this.amount = amount;
        this.aspect = aspect;
    }

    @Nonnull
    private static List<AspectProviderCopy> convertJars(List<ProcessingComponent<?>> components) {
        if (components.size() == 1) {
            return Collections.singletonList((AspectProviderCopy)components.get(0).getProvidedComponent());
        }
        return Lists.transform(components, component -> component != null ? (AspectProviderCopy)component.getProvidedComponent() : null);
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType() instanceof ComponentAspect && cmp instanceof MachineComponentAspectProvider && cmp.ioType == this.getActionType();
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            list.add(new ProcessingComponent<AspectProviderCopy>(component.component(), new AspectProviderCopy(((AspectProviderCopy)component.providedComponent()).getOriginal()), component.tag()));
        }
        return list;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        List<AspectProviderCopy> jars = RequirementAspect.convertJars(components);
        switch (this.getActionType()) {
            case INPUT: {
                int taken = this.takeAll(jars, context, this.parallelism, true);
                if (taken >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.aspect.less");
            }
            case OUTPUT: {
                int added;
                if (this.ignoreOutputCheck || (added = this.addAll(jars, context, this.parallelism, true)) >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.aspect.out");
            }
        }
        return CraftCheck.success();
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.INPUT) {
            this.takeAll(RequirementAspect.convertJars(components), context, this.parallelism, false);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.OUTPUT) {
            this.addAll(RequirementAspect.convertJars(components), context, this.parallelism, false);
        }
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        int n;
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            int max;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    int n2 = this.takeAll(RequirementAspect.convertJars(components), context, 1.0f, true);
                    break;
                }
                case OUTPUT: {
                    int n2 = max = this.addAll(RequirementAspect.convertJars(components), context, 1.0f, true);
                }
            }
            if (max >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INPUT: {
                n = this.takeAll(RequirementAspect.convertJars(components), context, maxParallelism, true);
                break;
            }
            case OUTPUT: {
                n = this.addAll(RequirementAspect.convertJars(components), context, maxParallelism, true);
            }
        }
        return n;
    }

    private int addAll(List<AspectProviderCopy> jars, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toAdd = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.amount, false));
        int maxAdd = (int)((float)toAdd * maxMultiplier);
        int totalAdded = 0;
        for (AspectProviderCopy jar : jars) {
            int notAdded;
            if ((totalAdded += maxAdd - totalAdded - (notAdded = simulate ? jar.addToContainer(this.aspect, maxAdd - totalAdded) : jar.getOriginal().addToContainer(this.aspect, maxAdd - totalAdded))) < maxAdd) continue;
            break;
        }
        if (totalAdded < maxAdd) {
            return totalAdded / toAdd;
        }
        return totalAdded;
    }

    private int takeAll(List<AspectProviderCopy> jars, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toTake = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.amount, false));
        int maxTake = (int)((float)toTake * maxMultiplier);
        int totalTaken = 0;
        for (AspectProviderCopy jar : jars) {
            if (simulate) {
                int jarAmount = Math.min(jar.getAmount(), maxTake - totalTaken);
                if (jar.takeFromContainer(this.aspect, jarAmount)) {
                    totalTaken += jarAmount;
                }
            } else {
                int jarAmount;
                TileJarFillable original = jar.getOriginal();
                if (original.takeFromContainer(this.aspect, jarAmount = Math.min(original.amount, maxTake - totalTaken))) {
                    totalTaken += jarAmount;
                }
            }
            if (totalTaken < maxTake) continue;
            break;
        }
        if (totalTaken < maxTake) {
            return totalTaken / toTake;
        }
        return totalTaken;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "error.modularmachinery.component.invalid";
    }

    public RequirementAspect deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementAspect deepCopyModified(List<RecipeModifier> list) {
        int amount = Math.round(RecipeModifier.applyModifiers(list, this, (float)this.amount, false));
        return new RequirementAspect(this.actionType, amount, this.aspect);
    }

    public JEIComponentAspect provideJEIComponent() {
        return new JEIComponentAspect(this);
    }
}

