/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.helper;

import kport.modularmagic.common.tile.TileLifeEssenceProvider;

public class LifeEssenceProviderCopy {
    private final TileLifeEssenceProvider original;
    private int lifeEssenceCache;

    public LifeEssenceProviderCopy(TileLifeEssenceProvider original) {
        this.original = original;
        this.lifeEssenceCache = original.getLifeEssenceCache();
    }

    public TileLifeEssenceProvider getOriginal() {
        return this.original;
    }

    public int getLifeEssenceCache() {
        return this.lifeEssenceCache;
    }

    public int getOrbCapacity() {
        return this.original.getOrbCapacity();
    }

    public int addLifeEssenceCache(int amount) {
        int orbCapacity = this.getOrbCapacity();
        if (orbCapacity <= 0) {
            return 0;
        }
        int maxCapacity = orbCapacity / 10;
        int maxCanAdd = maxCapacity - this.lifeEssenceCache;
        if (maxCanAdd <= 0) {
            return 0;
        }
        int added = Math.min(amount, maxCanAdd);
        this.lifeEssenceCache += added;
        return added;
    }

    public int removeLifeEssenceCache(int amount) {
        int maxCanConsume = Math.min(this.lifeEssenceCache, amount);
        this.lifeEssenceCache -= maxCanConsume;
        return maxCanConsume;
    }
}

