/*
 * Decompiled with CFR 0.152.
 */
package ink.ikx.mmce.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import github.kasuminova.mmce.common.network.PktAutoAssemblyRequest;
import github.kasuminova.mmce.common.util.DynamicPattern;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.client.util.DynamicMachineRenderContext;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockFactoryController;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.BlockArrayCache;
import ink.ikx.mmce.common.assembly.MachineAssembly;
import ink.ikx.mmce.common.assembly.MachineAssemblyManager;
import ink.ikx.mmce.common.utils.StructureIngredient;
import ink.ikx.mmce.core.AssemblyConfig;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AssemblyEventHandler {
    public static final AssemblyEventHandler INSTANCE = new AssemblyEventHandler();
    private static final Cache<EntityPlayer, Boolean> ASSEMBLY_ACCESS_TOKEN = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack itemStack = stack = event.getHand() == EnumHand.MAIN_HAND ? event.getItemStack() : player.func_184586_b(EnumHand.MAIN_HAND);
        if (player.func_70093_af()) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileMultiblockMachineController)) {
            return;
        }
        TileMultiblockMachineController ctrl = (TileMultiblockMachineController)tileEntity;
        if (stack.func_77973_b().equals((Object)ItemsMM.blueprint)) {
            if (world.field_72995_K || event.getHand() != EnumHand.MAIN_HAND) {
                return;
            }
            if (AssemblyEventHandler.getBlueprint(ctrl).func_190926_b()) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                if (!player.func_184812_l_()) {
                    stack.func_190920_e(stack.func_190916_E() - 1);
                }
                ctrl.getInventory().setStackInSlot(0, copy);
            }
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        Item item = Optional.ofNullable(Item.func_111206_d((String)AssemblyConfig.itemName)).orElse(Items.field_151055_y);
        if (stack.func_77969_a(new ItemStack(item, 1, AssemblyConfig.itemMeta))) {
            if (world.field_72995_K && event.getHand() == EnumHand.MAIN_HAND) {
                this.sendAssemblyRequestToServer(pos);
            }
            if (!world.field_72995_K && event.getHand() == EnumHand.MAIN_HAND && ASSEMBLY_ACCESS_TOKEN.getIfPresent((Object)player) == null) {
                ASSEMBLY_ACCESS_TOKEN.put((Object)player, (Object)true);
            }
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void sendAssemblyRequestToServer(BlockPos pos) {
        ClientProxy.clientScheduler.addRunnable(() -> {
            int dynamicPatternSize = 0;
            DynamicMachineRenderContext context = ClientProxy.renderHelper.getContext();
            if (context != null) {
                dynamicPatternSize = context.getDynamicPatternSize();
            }
            ModularMachinery.NET_CHANNEL.sendToServer((IMessage)new PktAutoAssemblyRequest(pos, (short)dynamicPatternSize));
        }, 1);
    }

    public void processAutoAssembly(EntityPlayer player, ItemStack handStack, BlockPos pos, short dynamicPatternSize) {
        Boolean access = (Boolean)ASSEMBLY_ACCESS_TOKEN.getIfPresent((Object)player);
        if (access == null) {
            return;
        }
        if (!access.booleanValue()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.too_quickly", new Object[0]));
            return;
        }
        ASSEMBLY_ACCESS_TOKEN.put((Object)player, (Object)false);
        World world = player.field_70170_p;
        TileEntity te = world.func_175625_s(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        Item item = Item.func_111206_d((String)AssemblyConfig.itemName);
        if (item == null) {
            item = Items.field_151055_y;
        }
        if (player.func_70093_af()) {
            return;
        }
        if (!(te instanceof TileMultiblockMachineController)) {
            return;
        }
        TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
        if (handStack.func_77969_a(new ItemStack(item, 1, AssemblyConfig.itemMeta))) {
            DynamicMachine machine = ctrl.getBlueprintMachine();
            if (machine == null) {
                if (block instanceof BlockController) {
                    machine = ((BlockController)block).getParentMachine();
                }
                if (block instanceof BlockFactoryController) {
                    machine = ((BlockFactoryController)block).getParentMachine();
                }
            }
            AssemblyEventHandler.assemblyBefore(machine, player, pos, dynamicPatternSize);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (event.phase == TickEvent.Phase.START || world.field_72995_K || world.func_82737_E() % (long)AssemblyConfig.tickBlock != 0L) {
            return;
        }
        Collection<MachineAssembly> assemblies = MachineAssemblyManager.getMachineAssemblyListFromPlayer(player);
        if (assemblies == null || assemblies.isEmpty()) {
            return;
        }
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
            for (MachineAssembly assembly : assemblies) {
                if (assembly.isControllerInvalid()) {
                    MachineAssemblyManager.removeMachineAssembly(assembly.getCtrlPos());
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.cancelled", new Object[0]));
                    return;
                }
                assembly.assembly(true);
                if (!assembly.isCompleted()) continue;
                MachineAssemblyManager.removeMachineAssembly(assembly.getCtrlPos());
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.success", new Object[0]));
            }
        });
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MachineAssemblyManager.removeMachineAssembly(event.player);
    }

    private static void assemblyBefore(DynamicMachine machine, EntityPlayer player, BlockPos pos, int dynamicPatternSize) {
        if (machine == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.no_machine", new Object[0]));
            return;
        }
        if (MachineAssemblyManager.checkMachineExist(pos)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.already_assembly", new Object[0]));
            return;
        }
        EnumFacing controllerFacing = (EnumFacing)player.field_70170_p.func_180495_p(pos).func_177229_b(BlockController.FACING);
        BlockArray machinePattern = new BlockArray(BlockArrayCache.getBlockArrayCache(machine.getPattern(), controllerFacing));
        Map<String, DynamicPattern> dynamicPatterns = machine.getDynamicPatterns();
        for (DynamicPattern pattern : dynamicPatterns.values()) {
            dynamicPatternSize = Math.max(dynamicPatternSize, pattern.getMinSize());
        }
        for (DynamicPattern pattern : dynamicPatterns.values()) {
            pattern.addPatternToBlockArray(machinePattern, Math.min(Math.max(pattern.getMinSize(), dynamicPatternSize), pattern.getMaxSize()), pattern.getFaces().iterator().next(), controllerFacing);
        }
        MachineAssembly assembly = new MachineAssembly(player.field_70170_p, pos, player, StructureIngredient.of(player.field_70170_p, pos, machinePattern));
        if (player.func_184812_l_()) {
            assembly.assemblyCreative();
            return;
        }
        if (MachineAssembly.checkAllItems(player, assembly.getIngredient().copy())) {
            assembly.buildIngredients(false);
            MachineAssemblyManager.addMachineAssembly(assembly);
            return;
        }
        if (!AssemblyConfig.needAllBlocks) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.partial_assembly", new Object[0]));
            assembly.buildIngredients(false);
            MachineAssemblyManager.addMachineAssembly(assembly);
        }
    }

    private static ItemStack getBlueprint(TileMultiblockMachineController controller) {
        return controller.getInventory().getStackInSlot(0);
    }
}

