/*
 * Decompiled with CFR 0.152.
 */
package ink.ikx.mmce.common.utils;

import github.kasuminova.mmce.common.machine.pattern.SpecialItemBlockProxy;
import github.kasuminova.mmce.common.machine.pattern.SpecialItemBlockProxyRegistry;
import hellfirepvp.modularmachinery.common.block.BlockController;
import ink.ikx.mmce.common.utils.FluidUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;

public class StackUtils {
    public static boolean isNotEmpty(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != Items.field_151117_aB;
    }

    public static boolean isStackFilter(ItemStack stack) {
        return StackUtils.isNotEmpty(stack) && !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockController);
    }

    public static ItemStack getStackFromBlockState(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockFluidBase) {
            return FluidUtil.getFilledBucket((FluidStack)new FluidStack(((IFluidBlock)block).getFluid(), 1000));
        }
        if (block instanceof BlockLiquid) {
            Material m = state.func_185904_a();
            if (m == Material.field_151587_i) {
                return new ItemStack(Items.field_151129_at);
            }
            if (m == Material.field_151586_h) {
                return new ItemStack(Items.field_151131_as);
            }
        }
        return new ItemStack(Item.func_150898_a((Block)block), 1, block.func_180651_a(state));
    }

    public static ItemStack getStackFromBlockState(IBlockState state, BlockPos pos, World world) {
        SpecialItemBlockProxy specialItemBlockProxy;
        ItemStack rawStack = ItemStack.field_190927_a;
        try {
            rawStack = state.func_177230_c().getPickBlock(state, new RayTraceResult(Vec3d.field_186680_a, EnumFacing.UP, pos), world, pos, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rawStack.func_190926_b()) {
            rawStack = StackUtils.getStackFromBlockState(state);
        }
        if ((specialItemBlockProxy = SpecialItemBlockProxyRegistry.INSTANCE.getValidProxy(rawStack)) != null) {
            return specialItemBlockProxy.getTrueStack(world.func_180495_p(pos), world.func_175625_s(pos));
        }
        return rawStack;
    }

    public static ItemStack hasStacks(List<ItemStack> inputStacks, List<ItemStack> outputStacks, boolean isRemove) {
        return outputStacks.stream().filter(stack -> StackUtils.isNotEmpty(StackUtils.hasStack(stack, inputStacks, isRemove))).findFirst().orElse(ItemStack.field_190927_a);
    }

    public static int getIndex(List<ItemStack> stacks, ItemStack stack) {
        for (int i = 0; i < stacks.size(); ++i) {
            if (!stacks.get(i).func_77969_a(stack)) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack hasStack(ItemStack stack, List<ItemStack> stacks, boolean isRemove) {
        for (ItemStack stackInSlot : stacks) {
            ItemStack copy = stackInSlot.func_77946_l();
            if (stackInSlot.func_190926_b()) continue;
            if (FluidUtils.areFluidHandler(stack, stackInSlot)) {
                if (!FluidUtils.equalsFluidFromStack(stackInSlot, stack)) continue;
                if (stackInSlot.func_77973_b() instanceof ItemBucket || stackInSlot.func_77973_b() instanceof UniversalBucket) {
                    if (isRemove) {
                        stackInSlot.func_190918_g(stack.func_190916_E());
                    }
                    return copy;
                }
                return ItemStack.field_190927_a;
            }
            if (!stackInSlot.func_77969_a(stack) || stackInSlot.func_190916_E() < stack.func_190916_E()) continue;
            if (isRemove) {
                stackInSlot.func_190918_g(stack.func_190916_E());
            }
            return copy;
        }
        return ItemStack.field_190927_a;
    }
}

