/*
 * Decompiled with CFR 0.152.
 */
package ink.ikx.mmce.common.utils;

import ink.ikx.mmce.common.utils.MiscUtils;
import ink.ikx.mmce.common.utils.StackUtils;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidUtils {
    public static boolean isFluidHandler(ItemStack stack) {
        return StackUtils.isNotEmpty(stack) && Objects.nonNull(FluidUtil.getFluidHandler((ItemStack)stack));
    }

    public static boolean areFluidHandler(ItemStack ... stacks) {
        return Arrays.stream(stacks).allMatch(FluidUtils::isFluidHandler);
    }

    public static FluidStack getFluidFromHandler(ItemStack stack) {
        if (FluidUtils.isFluidHandler(stack)) {
            IFluidTankProperties[] tank = FluidUtil.getFluidHandler((ItemStack)stack).getTankProperties();
            return tank.length == 0 ? null : tank[0].getContents();
        }
        return null;
    }

    public static boolean equalsFluidFromStack(ItemStack stackA, ItemStack stackB) {
        FluidStack fluidA = FluidUtils.getFluidFromHandler(stackA);
        FluidStack fluidB = FluidUtils.getFluidFromHandler(stackB);
        if (MiscUtils.areNull(fluidA, fluidB)) {
            return false;
        }
        return fluidA.containsFluid(fluidB);
    }

    public static FluidStack getFluidStackFromBlockState(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockFluidBase) {
            return new FluidStack(((IFluidBlock)block).getFluid(), 1000);
        }
        if (block instanceof BlockLiquid) {
            Material material = state.func_185904_a();
            if (material == Material.field_151586_h) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (material == Material.field_151587_i) {
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
        }
        return null;
    }
}

