/*
 * Decompiled with CFR 0.152.
 */
package ink.ikx.mmce.common.assembly;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.network.PktAssemblyReport;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import ink.ikx.mmce.common.utils.FluidUtils;
import ink.ikx.mmce.common.utils.StructureIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MachineAssembly {
    private final World world;
    private final BlockPos ctrlPos;
    private final EntityPlayer player;
    private StructureIngredient ingredient;

    public MachineAssembly(World world, BlockPos ctrlPos, EntityPlayer player, StructureIngredient ingredient) {
        this.world = world;
        this.ctrlPos = ctrlPos;
        this.player = player;
        this.ingredient = ingredient;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getCtrlPos() {
        return this.ctrlPos;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public StructureIngredient getIngredient() {
        return this.ingredient;
    }

    public void buildIngredients(boolean consumeInventory) {
        Object inventory = this.player.field_71071_by.field_70462_a;
        if (!consumeInventory) {
            inventory = inventory.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        }
        List<StructureIngredient.ItemIngredient> newItemIngredients = MachineAssembly.buildItemIngredients((List<ItemStack>)inventory, this.ingredient.itemIngredient());
        List<StructureIngredient.FluidIngredient> newFluidIngredients = MachineAssembly.buildFluidIngredients((List<ItemStack>)inventory, this.ingredient.fluidIngredient());
        this.ingredient = new StructureIngredient(newItemIngredients, newFluidIngredients);
    }

    public static List<StructureIngredient.FluidIngredient> buildFluidIngredients(List<ItemStack> inventory, List<StructureIngredient.FluidIngredient> fluidIngredients) {
        ArrayList<StructureIngredient.FluidIngredient> result = new ArrayList<StructureIngredient.FluidIngredient>();
        List<IFluidHandlerItem> fluidHandlers = MachineAssembly.getFluidHandlerItems(inventory);
        Iterator<StructureIngredient.FluidIngredient> fluidIngredientIter = fluidIngredients.iterator();
        block0: while (fluidIngredientIter.hasNext()) {
            StructureIngredient.FluidIngredient fluidIngredient = fluidIngredientIter.next();
            BlockPos pos = fluidIngredient.pos();
            for (Tuple<FluidStack, IBlockState> tuple : fluidIngredient.ingredientList()) {
                FluidStack required = (FluidStack)tuple.func_76341_a();
                IBlockState state = (IBlockState)tuple.func_76340_b();
                if (!MachineAssembly.consumeInventoryFluid(required, fluidHandlers)) continue;
                result.add(new StructureIngredient.FluidIngredient(pos, Collections.singletonList(new Tuple((Object)required, (Object)state))));
                fluidIngredientIter.remove();
                continue block0;
            }
        }
        return result;
    }

    private static List<IFluidHandlerItem> getFluidHandlerItems(List<ItemStack> inventory) {
        ArrayList<IFluidHandlerItem> fluidHandlers = new ArrayList<IFluidHandlerItem>();
        for (ItemStack invStack : inventory) {
            IFluidHandlerItem fluidHandler;
            Item item = invStack.func_77973_b();
            if (item instanceof UniversalBucket || item == Items.field_151129_at || item == Items.field_151131_as || !FluidUtils.isFluidHandler(invStack) || (fluidHandler = FluidUtil.getFluidHandler((ItemStack)invStack)) == null) continue;
            fluidHandlers.add(fluidHandler);
        }
        return fluidHandlers;
    }

    public static List<StructureIngredient.ItemIngredient> buildItemIngredients(List<ItemStack> inventory, List<StructureIngredient.ItemIngredient> itemIngredients) {
        ArrayList<StructureIngredient.ItemIngredient> result = new ArrayList<StructureIngredient.ItemIngredient>();
        Iterator<StructureIngredient.ItemIngredient> iterator = itemIngredients.iterator();
        block0: while (iterator.hasNext()) {
            StructureIngredient.ItemIngredient ingredient = iterator.next();
            for (Tuple<ItemStack, IBlockState> tuple : ingredient.ingredientList()) {
                ItemStack required = (ItemStack)tuple.func_76341_a();
                if (!MachineAssembly.consumeInventoryItem(required, inventory)) continue;
                result.add(new StructureIngredient.ItemIngredient(ingredient.pos(), Collections.singletonList(tuple), ingredient.nbt()));
                iterator.remove();
                continue block0;
            }
        }
        return result;
    }

    public static void searchAndRemoveContainItem(List<ItemStack> inventory, List<StructureIngredient.ItemIngredient> itemIngredients) {
        Iterator<StructureIngredient.ItemIngredient> itemIngredientIter = itemIngredients.iterator();
        block0: while (itemIngredientIter.hasNext()) {
            StructureIngredient.ItemIngredient ingredient = itemIngredientIter.next();
            for (Tuple<ItemStack, IBlockState> tuple : ingredient.ingredientList()) {
                ItemStack required = (ItemStack)tuple.func_76341_a();
                if (!required.func_190926_b() && !MachineAssembly.consumeInventoryItem(required, inventory)) continue;
                itemIngredientIter.remove();
                continue block0;
            }
        }
    }

    public static void searchAndRemoveContainFluid(List<ItemStack> inventory, List<StructureIngredient.FluidIngredient> fluidIngredients) {
        List<IFluidHandlerItem> fluidHandlers = MachineAssembly.getFluidHandlerItems(inventory);
        Iterator<StructureIngredient.FluidIngredient> fluidIngredientIter = fluidIngredients.iterator();
        block0: while (fluidIngredientIter.hasNext()) {
            StructureIngredient.FluidIngredient fluidIngredient = fluidIngredientIter.next();
            for (Tuple<FluidStack, IBlockState> tuple : fluidIngredient.ingredientList()) {
                FluidStack required = (FluidStack)tuple.func_76341_a();
                if (!MachineAssembly.consumeInventoryFluid(required, fluidHandlers)) continue;
                fluidIngredientIter.remove();
                continue block0;
            }
        }
    }

    public static boolean checkAllItems(EntityPlayer player, StructureIngredient ingredient) {
        List<ItemStack> inventory = player.field_71071_by.field_70462_a.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        List<StructureIngredient.ItemIngredient> itemIngredientList = ingredient.itemIngredient();
        List<StructureIngredient.FluidIngredient> fluidIngredientList = ingredient.fluidIngredient();
        MachineAssembly.searchAndRemoveContainItem(inventory, itemIngredientList);
        MachineAssembly.searchAndRemoveContainFluid(inventory, fluidIngredientList);
        if (itemIngredientList.isEmpty() && fluidIngredientList.isEmpty()) {
            return true;
        }
        List<List<ItemStack>> itemStackIngList = MachineAssembly.getItemStackIngList(itemIngredientList);
        List<List<FluidStack>> fluidStackIngList = MachineAssembly.getFluidStackIngList(fluidIngredientList);
        PktAssemblyReport pkt = new PktAssemblyReport(itemStackIngList, fluidStackIngList);
        if (player instanceof EntityPlayerMP) {
            ModularMachinery.NET_CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        }
        return false;
    }

    private static List<List<FluidStack>> getFluidStackIngList(List<StructureIngredient.FluidIngredient> fluidIngredientList) {
        ArrayList<List<FluidStack>> fluidStackIngList = new ArrayList<List<FluidStack>>();
        block0: for (StructureIngredient.FluidIngredient ingredient : fluidIngredientList) {
            if (ingredient.ingredientList().isEmpty()) continue;
            List stackIngList = ingredient.ingredientList().stream().map(Tuple::func_76341_a).collect(Collectors.toList());
            if (stackIngList.size() == 1) {
                FluidStack ing = (FluidStack)stackIngList.get(0);
                for (List list : fluidStackIngList) {
                    FluidStack another;
                    if (list.size() != 1 || !ing.isFluidEqual(another = (FluidStack)list.get(0))) continue;
                    another.amount += 1000;
                    continue block0;
                }
            }
            fluidStackIngList.add(stackIngList);
        }
        return fluidStackIngList;
    }

    private static List<List<ItemStack>> getItemStackIngList(List<StructureIngredient.ItemIngredient> itemIngredientList) {
        ArrayList<List<ItemStack>> stackList = new ArrayList<List<ItemStack>>();
        block0: for (StructureIngredient.ItemIngredient itemIng : itemIngredientList) {
            if (itemIng.ingredientList().isEmpty()) continue;
            List stackIngList = itemIng.ingredientList().stream().map(Tuple::func_76341_a).collect(Collectors.toList());
            if (stackIngList.size() == 1) {
                ItemStack ing = (ItemStack)stackIngList.get(0);
                for (List list : stackList) {
                    ItemStack anotherInput;
                    if (list.size() != 1 || !ItemUtils.matchStacks(ing, anotherInput = (ItemStack)list.get(0))) continue;
                    anotherInput.func_190917_f(1);
                    continue block0;
                }
            }
            ArrayList<ItemStack> filteredStackIngList = new ArrayList<ItemStack>();
            block2: for (ItemStack itemStack : stackIngList) {
                for (ItemStack filtered : filteredStackIngList) {
                    if (!ItemUtils.matchStacks(itemStack, filtered)) continue;
                    continue block2;
                }
                filteredStackIngList.add(itemStack);
            }
            stackList.add(filteredStackIngList);
        }
        return stackList;
    }

    public boolean isCompleted() {
        return this.ingredient.itemIngredient().isEmpty() && this.ingredient.fluidIngredient().isEmpty();
    }

    public boolean isControllerInvalid() {
        TileEntity te = this.world.func_175625_s(this.ctrlPos);
        return !(te instanceof TileMultiblockMachineController);
    }

    public void assembly(boolean consumeInventory) {
        List<StructureIngredient.ItemIngredient> itemIngredient = this.ingredient.itemIngredient();
        List<StructureIngredient.FluidIngredient> fluidIngredient = this.ingredient.fluidIngredient();
        if (!itemIngredient.isEmpty()) {
            this.assemblyItemBlocks(consumeInventory, itemIngredient);
        } else if (!fluidIngredient.isEmpty()) {
            this.assemblyFluidBlocks(consumeInventory, fluidIngredient);
        }
    }

    public void assemblyCreative() {
        IBlockState state;
        List<Tuple<ItemStack, IBlockState>> ingredientList;
        for (StructureIngredient.ItemIngredient itemIngredient : this.ingredient.itemIngredient()) {
            ingredientList = itemIngredient.ingredientList();
            if (ingredientList.isEmpty()) continue;
            state = (IBlockState)ingredientList.get(0).func_76340_b();
            this.world.func_175656_a(this.ctrlPos.func_177971_a((Vec3i)itemIngredient.pos()), state);
        }
        for (StructureIngredient.FluidIngredient fluidIngredient : this.ingredient.fluidIngredient()) {
            ingredientList = fluidIngredient.ingredientList();
            if (ingredientList.isEmpty()) continue;
            state = (IBlockState)ingredientList.get(0).func_76340_b();
            this.world.func_175656_a(this.ctrlPos.func_177971_a((Vec3i)fluidIngredient.pos()), state);
        }
        this.world.func_184133_a(null, this.ctrlPos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.success", new Object[0]));
    }

    private void assemblyItemBlocks(boolean consumeInventory, List<StructureIngredient.ItemIngredient> itemIngredient) {
        Iterator<StructureIngredient.ItemIngredient> iterator = itemIngredient.iterator();
        StructureIngredient.ItemIngredient ingredient = iterator.next();
        BlockPos realPos = this.ctrlPos.func_177971_a((Vec3i)ingredient.pos());
        if (!MachineAssembly.replaceCheck(realPos, this.world, this.player)) {
            iterator.remove();
            return;
        }
        Tuple<ItemStack, IBlockState> tuple = ingredient.ingredientList().get(0);
        ItemStack required = (ItemStack)tuple.func_76341_a();
        IBlockState state = (IBlockState)tuple.func_76340_b();
        if (consumeInventory && !MachineAssembly.consumeInventoryItem(required, (List<ItemStack>)this.player.field_71071_by.field_70462_a)) {
            String posToString = MiscUtils.posToString((Vec3i)realPos);
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.missing", new Object[]{posToString}));
            ArrayList<List<ItemStack>> itemStackIngList = new ArrayList<List<ItemStack>>();
            itemStackIngList.add(Collections.singletonList(required));
            PktAssemblyReport pkt = new PktAssemblyReport(itemStackIngList, new ArrayList<List<FluidStack>>());
            if (this.player instanceof EntityPlayerMP) {
                ModularMachinery.NET_CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)this.player);
            }
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.skipped", new Object[]{posToString}));
            iterator.remove();
            return;
        }
        IBlockState originalBlockState = this.getWorld().func_180495_p(realPos);
        this.world.func_175656_a(realPos, state);
        BlockSnapshot blockSnapshot = new BlockSnapshot(this.world, realPos, state);
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, originalBlockState, this.player, EnumHand.MAIN_HAND);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            this.world.func_175656_a(realPos, originalBlockState);
            this.player.field_71071_by.func_70441_a(required);
        } else {
            this.world.func_184133_a(null, realPos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            TileEntity te = this.world.func_175625_s(realPos);
            if (te != null && ingredient.nbt() != null) {
                try {
                    te.func_145839_a(ingredient.nbt());
                }
                catch (Exception e) {
                    ModularMachinery.log.warn("Failed to apply NBT to TileEntity!", (Throwable)e);
                    this.world.func_175713_t(realPos);
                    this.world.func_175690_a(realPos, state.func_177230_c().createTileEntity(this.world, state));
                }
            }
        }
        iterator.remove();
    }

    private void assemblyFluidBlocks(boolean consumeInventory, List<StructureIngredient.FluidIngredient> fluidIngredient) {
        Iterator<StructureIngredient.FluidIngredient> iterator = fluidIngredient.iterator();
        StructureIngredient.FluidIngredient ingredient = iterator.next();
        BlockPos realPos = this.ctrlPos.func_177971_a((Vec3i)ingredient.pos());
        if (!MachineAssembly.replaceCheck(realPos, this.world, this.player)) {
            iterator.remove();
            return;
        }
        Tuple<FluidStack, IBlockState> tuple = ingredient.ingredientList().get(0);
        FluidStack required = (FluidStack)tuple.func_76341_a();
        IBlockState state = (IBlockState)tuple.func_76340_b();
        if (consumeInventory && !MachineAssembly.consumeInventoryFluid(required, MachineAssembly.getFluidHandlerItems((List<ItemStack>)this.player.field_71071_by.field_70462_a))) {
            String posToString = MiscUtils.posToString((Vec3i)realPos);
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.missing", new Object[]{posToString}));
            ArrayList<List<FluidStack>> fluidStackIngList = new ArrayList<List<FluidStack>>();
            fluidStackIngList.add(Collections.singletonList(required));
            PktAssemblyReport pkt = new PktAssemblyReport(new ArrayList<List<ItemStack>>(), fluidStackIngList);
            if (this.player instanceof EntityPlayerMP) {
                ModularMachinery.NET_CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)this.player);
            }
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.skipped", new Object[]{posToString}));
            iterator.remove();
            return;
        }
        IBlockState originalBlockState = this.getWorld().func_180495_p(realPos);
        this.world.func_175656_a(realPos, state);
        BlockSnapshot blockSnapshot = new BlockSnapshot(this.world, realPos, state);
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, originalBlockState, this.player, EnumHand.MAIN_HAND);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            this.world.func_175656_a(realPos, originalBlockState);
            MachineAssembly.fillInventoryFluid(required, MachineAssembly.getFluidHandlerItems((List<ItemStack>)this.player.field_71071_by.field_70462_a));
        } else {
            this.world.func_184133_a(null, realPos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        iterator.remove();
    }

    public static boolean consumeInventoryItem(ItemStack required, List<ItemStack> inventory) {
        for (ItemStack invStack : inventory) {
            if (!ItemUtils.matchStacks(invStack, required)) continue;
            invStack.func_190918_g(required.func_190916_E());
            return true;
        }
        return false;
    }

    public static boolean fillInventoryFluid(FluidStack required, List<IFluidHandlerItem> fluidHandlers) {
        for (IFluidHandlerItem fluidHandler : fluidHandlers) {
            FluidStack drained = fluidHandler.drain(required.copy(), false);
            if (drained != null) continue;
            fluidHandler.fill(required.copy(), true);
            return true;
        }
        return false;
    }

    public static boolean consumeInventoryFluid(FluidStack required, List<IFluidHandlerItem> fluidHandlers) {
        for (IFluidHandlerItem fluidHandler : fluidHandlers) {
            FluidStack drained = fluidHandler.drain(required.copy(), false);
            if (drained == null || !drained.containsFluid(required)) continue;
            fluidHandler.drain(required.copy(), true);
            return true;
        }
        return false;
    }

    public static boolean replaceCheck(BlockPos realPos, World world, EntityPlayer player) {
        IBlockState blockState = world.func_180495_p(realPos);
        Block block = blockState.func_177230_c();
        if (world.func_175623_d(realPos) || block instanceof IPlantable || block instanceof BlockLiquid || block instanceof IFluidBlock) {
            return true;
        }
        String posToString = MiscUtils.posToString((Vec3i)realPos);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.cannot_replace", new Object[]{posToString}));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.skipped", new Object[]{posToString}));
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MachineAssembly)) {
            return false;
        }
        MachineAssembly another = (MachineAssembly)o;
        return this.ctrlPos.equals((Object)another.ctrlPos);
    }

    public int hashCode() {
        return this.ctrlPos != null ? this.ctrlPos.hashCode() : 0;
    }
}

