/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util.nbt;

import com.google.common.base.Optional;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class NBTHelper {
    public static void setBlockState(NBTTagCompound cmp, String key, IBlockState state) {
        NBTTagCompound serialized = NBTHelper.getBlockStateNBTTag(state);
        if (serialized != null) {
            cmp.func_74782_a(key, (NBTBase)serialized);
        }
    }

    @Nullable
    public static IBlockState getBlockState(NBTTagCompound cmp, String key) {
        return NBTHelper.getBlockStateFromTag(cmp.func_74775_l(key));
    }

    @Nullable
    public static NBTTagCompound getBlockStateNBTTag(IBlockState state) {
        if (state.func_177230_c().getRegistryName() == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("registryName", state.func_177230_c().getRegistryName().toString());
        NBTTagList properties = new NBTTagList();
        for (IProperty property : state.func_177227_a()) {
            NBTTagCompound propTag = new NBTTagCompound();
            try {
                propTag.func_74778_a("value", property.func_177702_a(state.func_177229_b(property)));
            }
            catch (Exception exc) {
                return null;
            }
            propTag.func_74778_a("property", property.func_177701_a());
            properties.func_74742_a((NBTBase)propTag);
        }
        tag.func_74782_a("properties", (NBTBase)properties);
        return tag;
    }

    @Nullable
    public static <T extends Comparable<T>> IBlockState getBlockStateFromTag(NBTTagCompound cmp) {
        ResourceLocation key = new ResourceLocation(cmp.func_74779_i("registryName"));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        if (block == null || block == Blocks.field_150350_a) {
            return null;
        }
        IBlockState state = block.func_176223_P();
        Collection properties = state.func_177227_a();
        NBTTagList list = cmp.func_150295_c("properties", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound propertyTag = list.func_150305_b(i);
            String valueStr = propertyTag.func_74779_i("value");
            String propertyStr = propertyTag.func_74779_i("property");
            IProperty match = MiscUtils.iterativeSearch(properties, prop -> prop.func_177701_a().equalsIgnoreCase(propertyStr));
            if (match == null) continue;
            try {
                Optional opt = match.func_185929_b(valueStr);
                if (!opt.isPresent()) continue;
                state = state.func_177226_a(match, (Comparable)opt.get());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }
}

