/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class PriorityProvider<T>
implements Iterable<T> {
    private final Collection<T> backingList;
    private final Function<Collection<T>, T> priorityFunction;

    public PriorityProvider(Collection<T> backingList, Function<Collection<T>, T> priorityProvider) {
        this.backingList = backingList;
        this.priorityFunction = priorityProvider;
    }

    @Override
    public Iterator<T> iterator() {
        return new PriorityIterator(Lists.newArrayList(this.backingList), this.priorityFunction);
    }

    private static class PriorityIterator<T>
    implements Iterator<T> {
        private final Collection<T> backingList;
        private final Function<Collection<T>, T> priorityFunction;
        private boolean prioritized = true;

        private PriorityIterator(Collection<T> backingList, Function<Collection<T>, T> priorityProvider) {
            this.backingList = backingList;
            this.priorityFunction = priorityProvider;
        }

        @Override
        public boolean hasNext() {
            return !this.backingList.isEmpty();
        }

        @Override
        public T next() {
            Object next;
            if (this.prioritized) {
                T element = this.priorityFunction.apply(this.backingList);
                if (element != null) {
                    this.backingList.remove(element);
                    return element;
                }
                this.prioritized = false;
            }
            if ((next = Iterables.getFirst(this.backingList, null)) != null) {
                this.backingList.remove(next);
            }
            return (T)next;
        }
    }
}

