/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import github.kasuminova.mmce.client.util.ItemStackUtils;
import github.kasuminova.mmce.common.util.concurrent.ReadWriteLockProvider;
import hellfirepvp.modularmachinery.common.tiles.base.SelectiveUpdateTileEntity;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import hellfirepvp.modularmachinery.common.util.IItemHandlerImpl;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class IOInventory
extends IItemHandlerImpl
implements ReadWriteLockProvider {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final TileEntitySynchronized owner;
    private Consumer<Integer> listener = null;

    private IOInventory(TileEntitySynchronized owner) {
        this.owner = owner;
    }

    public IOInventory(TileEntitySynchronized owner, int[] inSlots, int[] outSlots) {
        this(owner, inSlots, outSlots, EnumFacing.field_82609_l);
    }

    public IOInventory(TileEntitySynchronized owner, int[] inSlots, int[] outSlots, EnumFacing ... accessibleFrom) {
        super(inSlots, outSlots, accessibleFrom);
        this.owner = owner;
    }

    public static IOInventory deserialize(TileEntitySynchronized owner, NBTTagCompound tag) {
        IOInventory inv = new IOInventory(owner);
        inv.readNBT(tag);
        return inv;
    }

    public IOInventory setListener(Consumer<Integer> listener) {
        this.listener = listener;
        return this;
    }

    public TileEntitySynchronized getOwner() {
        return this.owner;
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        try {
            this.rwLock.writeLock().lock();
            super.setStackInSlot(slot, stack);
            this.notifyOwner();
            if (this.listener != null) {
                this.listener.accept(slot);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        try {
            (simulate ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            ItemStack inserted = this.insertItemInternal(slot, stack, simulate);
            if (!simulate) {
                if (this.listener != null) {
                    this.listener.accept(slot);
                }
                this.notifyOwner();
            }
            ItemStack itemStack = inserted;
            (simulate ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return itemStack;
        }
        catch (Throwable throwable) {
            (simulate ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        try {
            (simulate ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            ItemStack extracted = super.extractItem(slot, amount, simulate);
            if (!simulate) {
                if (this.listener != null) {
                    this.listener.accept(slot);
                }
                this.notifyOwner();
            }
            ItemStack itemStack = extracted;
            (simulate ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return itemStack;
        }
        catch (Throwable throwable) {
            (simulate ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    private void notifyOwner() {
        if (this.owner instanceof SelectiveUpdateTileEntity) {
            this.owner.markNoUpdateSync();
        } else {
            this.owner.markForUpdateSync();
        }
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("inSlots", this.inSlots);
        tag.func_74783_a("outSlots", this.outSlots);
        tag.func_74783_a("miscSlots", this.miscSlots);
        NBTTagList inv = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            IItemHandlerImpl.SlotStackHolder holder = this.inventory[slot];
            NBTTagCompound holderTag = new NBTTagCompound();
            ItemStack stack = holder.itemStack.get();
            holderTag.func_74768_a("holderId", slot);
            if (stack.func_190926_b()) {
                holderTag.func_74757_a("holderEmpty", true);
            } else {
                ItemStackUtils.writeNBTOversize(stack, holderTag);
            }
            inv.func_74742_a((NBTBase)holderTag);
        }
        tag.func_74782_a("inventoryArray", (NBTBase)inv);
        int[] sides = new int[this.accessibleSides.length];
        for (int i = 0; i < this.accessibleSides.length; ++i) {
            EnumFacing side = this.accessibleSides[i];
            sides[i] = side.ordinal();
        }
        tag.func_74783_a("sides", sides);
        return tag;
    }

    public void readNBT(NBTTagCompound tag) {
        this.inSlots = tag.func_74759_k("inSlots");
        this.outSlots = tag.func_74759_k("outSlots");
        this.miscSlots = tag.func_74759_k("miscSlots");
        NBTTagList list = tag.func_150295_c("inventoryArray", 10);
        int tagCount = list.func_74745_c();
        this.inventory = new IItemHandlerImpl.SlotStackHolder[tagCount];
        for (int i = 0; i < tagCount; ++i) {
            NBTTagCompound holderTag = list.func_150305_b(i);
            int slot = holderTag.func_74762_e("holderId");
            this.checkInventoryLength(slot);
            ItemStack stack = ItemStack.field_190927_a;
            if (!holderTag.func_74764_b("holderEmpty")) {
                stack = ItemStackUtils.readNBTOversize(holderTag);
            }
            IItemHandlerImpl.SlotStackHolder holder = new IItemHandlerImpl.SlotStackHolder(slot);
            holder.itemStack.set(stack);
            this.inventory[slot] = holder;
        }
        int[] sides = tag.func_74759_k("sides");
        this.accessibleSides = new EnumFacing[sides.length];
        for (int index = 0; index < sides.length; ++index) {
            int facingIndex = sides[index];
            this.accessibleSides[index] = EnumFacing.values()[facingIndex];
        }
    }

    public int calcRedstoneFromInventory() {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < this.getSlots(); ++j) {
            ItemStack itemstack = this.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(this.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)this.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    @Override
    @Nonnull
    public ReadWriteLock getRWLock() {
        return this.rwLock;
    }
}

