/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.common.collect.Lists;
import github.kasuminova.mmce.common.concurrent.Sync;
import github.kasuminova.mmce.common.util.IExtendedGasHandler;
import github.kasuminova.mmce.common.util.MultiFluidTank;
import github.kasuminova.mmce.common.util.MultiGasTank;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.machine.IOType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;

public class HybridFluidUtils {
    public static long doSimulateDrainOrFill(FluidStack drainOrFill, List<IFluidHandler> fluidHandlers, long maxDrainOrFill, IOType actionType) {
        long totalIO = 0L;
        FluidStack stack = drainOrFill.copy();
        for (IFluidHandler handler : fluidHandlers) {
            stack.amount = maxDrainOrFill - totalIO >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(maxDrainOrFill - totalIO);
            switch (actionType) {
                case INPUT: {
                    FluidStack drained = handler.drain(stack, false);
                    if (drained == null) break;
                    totalIO += (long)drained.amount;
                    break;
                }
                case OUTPUT: {
                    totalIO += (long)handler.fill(stack, false);
                }
            }
            if (totalIO < maxDrainOrFill) continue;
            break;
        }
        return totalIO;
    }

    public static void doDrainOrFill(FluidStack drainOrFill, long maxDrainOrFill, List<IFluidHandler> fluidHandlers, IOType actionType) {
        long[] totalIO = new long[]{maxDrainOrFill};
        FluidStack stack = drainOrFill.copy();
        for (IFluidHandler handler : fluidHandlers) {
            stack.amount = totalIO[0] >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)totalIO[0];
            Sync.executeSyncIfPresent(handler, () -> {
                switch (actionType) {
                    case INPUT: {
                        FluidStack drained = handler.drain(stack, true);
                        if (drained == null) break;
                        totalIO[0] = totalIO[0] - (long)drained.amount;
                        break;
                    }
                    case OUTPUT: {
                        totalIO[0] = totalIO[0] - (long)handler.fill(stack, true);
                    }
                }
            });
            if (totalIO[0] > 0L) continue;
            break;
        }
    }

    @Optional.Method(modid="mekanism")
    public static long doSimulateDrainOrFill(GasStack drainOrFill, List<IExtendedGasHandler> gasHandlers, long maxDrainOrFill, IOType actionType) {
        long totalIO = 0L;
        GasStack stack = drainOrFill.copy();
        block4: for (IExtendedGasHandler handler : gasHandlers) {
            stack.amount = maxDrainOrFill - totalIO >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(maxDrainOrFill - totalIO);
            switch (actionType) {
                case INPUT: {
                    GasStack drawn = handler.drawGas(stack, false);
                    if (drawn == null) break;
                    totalIO += (long)drawn.amount;
                    break;
                }
                case OUTPUT: {
                    if (!handler.canReceiveGas(null, stack.getGas())) continue block4;
                    totalIO += (long)handler.receiveGas(null, stack, false);
                }
            }
            if (totalIO < maxDrainOrFill) continue;
            break;
        }
        return totalIO;
    }

    @Optional.Method(modid="mekanism")
    public static void doDrainOrFill(GasStack drainOrFill, long maxDrainOrFill, List<IExtendedGasHandler> gasHandlers, IOType actionType) {
        long[] totalIO = new long[]{maxDrainOrFill};
        GasStack stack = drainOrFill.copy();
        for (IExtendedGasHandler handler : gasHandlers) {
            stack.amount = totalIO[0] >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)totalIO[0];
            Sync.executeSyncIfPresent(handler, () -> {
                switch (actionType) {
                    case INPUT: {
                        GasStack drawn = handler.drawGas(stack, true);
                        if (drawn == null) break;
                        totalIO[0] = totalIO[0] - (long)drawn.amount;
                        break;
                    }
                    case OUTPUT: {
                        if (!handler.canReceiveGas(null, stack.getGas())) {
                            return;
                        }
                        totalIO[0] = totalIO[0] - (long)handler.receiveGas(null, stack, true);
                    }
                }
            });
            if (totalIO[0] > 0L) continue;
            break;
        }
    }

    @Nonnull
    public static List<IFluidHandler> castFluidHandlerComponents(List<ProcessingComponent<?>> components) {
        if (components.size() == 1) {
            return Collections.singletonList((IFluidHandler)components.get(0).getProvidedComponent());
        }
        return Lists.transform(components, component -> component != null ? (IFluidHandler)component.getProvidedComponent() : null);
    }

    @Nonnull
    @Optional.Method(modid="mekanism")
    public static List<IExtendedGasHandler> castGasHandlerComponents(List<ProcessingComponent<?>> components) {
        LinkedList<IExtendedGasHandler> list = new LinkedList<IExtendedGasHandler>();
        for (ProcessingComponent<?> component : components) {
            Object providedComponent = component.getProvidedComponent();
            if (!(providedComponent instanceof IExtendedGasHandler)) continue;
            IExtendedGasHandler gasHandler = (IExtendedGasHandler)providedComponent;
            list.add(gasHandler);
        }
        return list;
    }

    @Nonnull
    public static List<ProcessingComponent<?>> copyFluidHandlerComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            Object providedComponent = component.getProvidedComponent();
            if (!(providedComponent instanceof IFluidHandler)) continue;
            ProcessingComponent<MultiFluidTank> objectProcessingComponent = new ProcessingComponent<MultiFluidTank>(component.component(), new MultiFluidTank((IFluidHandler)providedComponent), component.getTag());
            list.add(objectProcessingComponent);
        }
        return list;
    }

    @Nonnull
    public static List<ProcessingComponent<?>> copyGasHandlerComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            Object providedComponent = component.getProvidedComponent();
            if (!(providedComponent instanceof IGasHandler)) continue;
            ProcessingComponent<MultiGasTank> objectProcessingComponent = new ProcessingComponent<MultiGasTank>(component.component(), new MultiGasTank((IGasHandler)providedComponent), component.getTag());
            list.add(objectProcessingComponent);
        }
        return list;
    }
}

