/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class FileUtils {
    public static final int KB = 1024;
    public static final int MB = 0x100000;

    public static String readFile(File file) throws IOException {
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
        char[] chars = new char[FileUtils.formatBufferSize(file.length())];
        StringBuilder sb = new StringBuilder((int)file.length());
        try {
            int length;
            while ((length = reader.read(chars)) != -1) {
                sb.append(chars, 0, length);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    public static void writeFile(String content, File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Could not create file " + file.getAbsolutePath());
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }

    public static int formatBufferSize(long size) {
        if (size <= 1024L) {
            return (int)size;
        }
        if (size <= 0x100000L) {
            return 8192;
        }
        if (size <= 0x8000000L) {
            return 32768;
        }
        return 131072;
    }
}

