/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BlockInformationVariable {
    private final Map<String, BlockArray.BlockInformation> variables = new HashMap<String, BlockArray.BlockInformation>();

    public Map<String, BlockArray.BlockInformation> getDefinedVariables() {
        return this.variables;
    }

    public static class Deserializer
    implements JsonDeserializer<BlockInformationVariable> {
        public BlockInformationVariable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            BlockInformationVariable var = new BlockInformationVariable();
            JsonObject root = json.getAsJsonObject();
            for (Map.Entry entry : root.entrySet()) {
                JsonElement variableElement = (JsonElement)entry.getValue();
                if (variableElement.isJsonArray()) {
                    ArrayList descriptors = Lists.newArrayList();
                    JsonArray elements = variableElement.getAsJsonArray();
                    for (int i = 0; i < elements.size(); ++i) {
                        JsonElement p = elements.get(i);
                        if (!p.isJsonPrimitive() || !p.getAsJsonPrimitive().isString()) {
                            throw new JsonParseException("Elements of a variable have to be Blockstate descriptions! You cannot nest variables!");
                        }
                        descriptors.add(BlockArray.BlockInformation.getDescriptor(p.getAsString()));
                    }
                    var.variables.put((String)entry.getKey(), new BlockArray.BlockInformation(descriptors));
                    continue;
                }
                if (variableElement.isJsonPrimitive() && variableElement.getAsJsonPrimitive().isString()) {
                    var.variables.put((String)entry.getKey(), new BlockArray.BlockInformation(Lists.newArrayList((Object[])new IBlockStateDescriptor[]{BlockArray.BlockInformation.getDescriptor(variableElement.getAsString())})));
                    continue;
                }
                throw new JsonParseException("Variable '" + (String)entry.getKey() + "' has as its value neither an array of BlockState definitions nor a single BlockState as String!");
            }
            return var;
        }
    }
}

