/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import github.kasuminova.mmce.common.util.DynamicPattern;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.modifier.MultiBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import io.netty.util.collection.LongObjectHashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.EnumFacing;

public class BlockArrayCache {
    private static final LongObjectHashMap<EnumMap<EnumFacing, BlockArray>> BLOCK_ARRAY_CACHE_MAP = new LongObjectHashMap();
    private static final AtomicLong UID_COUNTER = new AtomicLong(0L);

    public static TaggedPositionBlockArray getBlockArrayCache(TaggedPositionBlockArray blockArray, EnumFacing facing) {
        return (TaggedPositionBlockArray)((EnumMap)BLOCK_ARRAY_CACHE_MAP.computeIfAbsent((Object)blockArray.uid, e -> new EnumMap(EnumFacing.class))).get(facing);
    }

    public static BlockArray getBlockArrayCache(BlockArray blockArray, EnumFacing facing) {
        return (BlockArray)((EnumMap)BLOCK_ARRAY_CACHE_MAP.computeIfAbsent((Object)blockArray.uid, e -> new EnumMap(EnumFacing.class))).get(facing);
    }

    public static synchronized void addBlockArrayCache(TaggedPositionBlockArray blockArray, EnumFacing facing) {
        ((EnumMap)BLOCK_ARRAY_CACHE_MAP.computeIfAbsent((Object)blockArray.uid, e -> new EnumMap(EnumFacing.class))).put(facing, blockArray);
    }

    public static synchronized void addBlockArrayCache(BlockArray blockArray, EnumFacing facing) {
        ((EnumMap)BLOCK_ARRAY_CACHE_MAP.computeIfAbsent((Object)blockArray.uid, e -> new EnumMap(EnumFacing.class))).put(facing, blockArray);
    }

    public static long nextUID() {
        return UID_COUNTER.getAndIncrement();
    }

    public static void buildCache(Collection<DynamicMachine> machines) {
        BLOCK_ARRAY_CACHE_MAP.clear();
        long start = System.currentTimeMillis();
        ModularMachinery.log.info("Building Machine Structure Cache...");
        machines.parallelStream().forEach(machine -> {
            TaggedPositionBlockArray blockArray = machine.getPattern();
            BlockArrayCache.buildBlockArrayCache(blockArray);
            BlockArrayCache.buildMultiBlockModifierCache(machine.getMultiBlockModifiers());
            for (DynamicPattern pattern : machine.getDynamicPatterns().values()) {
                BlockArrayCache.buildDynamicPatternCache(pattern.getPattern());
                TaggedPositionBlockArray patternEnd = pattern.getPatternEnd();
                if (patternEnd == null) continue;
                BlockArrayCache.buildDynamicPatternCache(patternEnd);
            }
        });
        ModularMachinery.log.info("Build Completed, Used " + (System.currentTimeMillis() - start) + "ms.");
    }

    private static void buildMultiBlockModifierCache(List<MultiBlockModifierReplacement> replacementList) {
        for (MultiBlockModifierReplacement replacement : replacementList) {
            BlockArray blockArray = replacement.getBlockArray();
            BlockArrayCache.buildBlockArrayCache(blockArray);
        }
    }

    private static void buildBlockArrayCache(BlockArray blockArray) {
        EnumFacing facing = EnumFacing.NORTH;
        blockArray.flushTileBlocksCache();
        BlockArrayCache.addBlockArrayCache(blockArray, facing);
        do {
            facing = facing.func_176735_f();
            blockArray = blockArray.rotateYCCW();
            blockArray.flushTileBlocksCache();
            BlockArrayCache.addBlockArrayCache(blockArray, facing);
        } while (facing != EnumFacing.NORTH);
    }

    private static void buildDynamicPatternCache(TaggedPositionBlockArray blockArray) {
        blockArray.flushTileBlocksCache();
        for (EnumFacing facing : EnumFacing.values()) {
            BlockArray rotated = blockArray;
            EnumFacing rotatedFacing = EnumFacing.NORTH;
            if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) continue;
            while (rotatedFacing != facing) {
                rotatedFacing = rotatedFacing.func_176735_f();
                rotated = rotated.rotateYCCW();
                rotated.flushTileBlocksCache();
            }
            BlockArrayCache.addBlockArrayCache(rotated, rotatedFacing);
        }
    }
}

