/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles.base;

import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.FluidHatchSize;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.SelectiveUpdateTileEntity;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import hellfirepvp.modularmachinery.common.util.HybridGasTank;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import hellfirepvp.modularmachinery.common.util.RedstoneHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(modid="mekanism", iface="mekanism.api.gas.IGasHandler"), @Optional.Interface(modid="mekanism", iface="mekanism.api.gas.ITubeConnection")})
public abstract class TileFluidTank
extends TileColorableMachineComponent
implements MachineComponentTile,
IGasHandler,
ITubeConnection,
SelectiveUpdateTileEntity {
    private HybridTank tank;
    private IOType ioType;
    private FluidHatchSize hatchSize;
    private int prevRedstoneLevel = 0;

    public TileFluidTank() {
    }

    public TileFluidTank(FluidHatchSize size, IOType type) {
        this.tank = size.buildTank(this, true, true);
        this.hatchSize = size;
        this.ioType = type;
    }

    @Optional.Method(modid="mekanism")
    private static boolean checkMekanismGasCapabilitiesPresence(Capability<?> capability) {
        return TileFluidTank.checkMekanismGasCapabilities(capability);
    }

    @Optional.Method(modid="mekanism")
    private static boolean checkMekanismGasCapabilities(Capability<?> capability) {
        String gasType = IGasHandler.class.getName();
        String tubeConnectionName = ITubeConnection.class.getName();
        return capability != null && (capability.getName().equals(gasType) || capability.getName().equals(tubeConnectionName));
    }

    public HybridTank getTank() {
        return this.tank;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (Mods.MEKANISM.isPresent() && TileFluidTank.checkMekanismGasCapabilitiesPresence(capability)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (Mods.MEKANISM.isPresent() && TileFluidTank.checkMekanismGasCapabilities(capability)) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.ioType = compound.func_74767_n("input") ? IOType.INPUT : IOType.OUTPUT;
        this.hatchSize = FluidHatchSize.values()[MathHelper.func_76125_a((int)compound.func_74762_e("size"), (int)0, (int)(FluidHatchSize.values().length - 1))];
        HybridTank newTank = this.hatchSize.buildTank(this, true, true);
        NBTTagCompound tankTag = compound.func_74775_l("tank");
        newTank.readFromNBT(tankTag);
        this.tank = newTank;
        if (Mods.MEKANISM.isPresent()) {
            this.readMekGasData(tankTag);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("input", this.ioType == IOType.INPUT);
        compound.func_74768_a("size", this.hatchSize.ordinal());
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        if (Mods.MEKANISM.isPresent()) {
            this.writeMekGasData(tankTag);
        }
        compound.func_74782_a("tank", (NBTBase)tankTag);
    }

    @Override
    public void markNoUpdate() {
        int redstoneLevel = RedstoneHelper.getRedstoneLevel(this);
        if (this.prevRedstoneLevel != redstoneLevel) {
            this.prevRedstoneLevel = redstoneLevel;
            this.requireUpdateComparatorLevel = true;
        }
        super.markNoUpdate();
        this.requireUpdateComparatorLevel = false;
    }

    @Override
    @Nullable
    public MachineComponent<?> provideComponent() {
        return new MachineComponent.FluidHatch(this.ioType){

            @Override
            public HybridTank getContainerProvider() {
                return TileFluidTank.this.tank;
            }
        };
    }

    @Optional.Method(modid="mekanism")
    public boolean canTubeConnect(EnumFacing side) {
        return true;
    }

    @Optional.Method(modid="mekanism")
    private void writeMekGasData(NBTTagCompound compound) {
        HybridTank hybridTank = this.tank;
        if (hybridTank instanceof HybridGasTank) {
            HybridGasTank gasTank = (HybridGasTank)hybridTank;
            gasTank.writeGasToNBT(compound);
        }
    }

    @Optional.Method(modid="mekanism")
    private void readMekGasData(NBTTagCompound compound) {
        HybridTank hybridTank = this.tank;
        if (hybridTank instanceof HybridGasTank) {
            HybridGasTank gasTank = (HybridGasTank)hybridTank;
            gasTank.readGasFromNBT(compound);
        }
    }

    @Optional.Method(modid="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        int n;
        HybridTank hybridTank = this.tank;
        if (hybridTank instanceof HybridGasTank) {
            HybridGasTank gasTank = (HybridGasTank)hybridTank;
            n = gasTank.receiveGas(side, stack, doTransfer);
        } else {
            n = 0;
        }
        return n;
    }

    @Optional.Method(modid="mekanism")
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        GasStack gasStack;
        HybridTank hybridTank = this.tank;
        if (hybridTank instanceof HybridGasTank) {
            HybridGasTank gasTank = (HybridGasTank)hybridTank;
            gasStack = gasTank.drawGas(side, amount, doTransfer);
        } else {
            gasStack = null;
        }
        return gasStack;
    }

    @Optional.Method(modid="mekanism")
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        HybridGasTank gasTank;
        HybridTank hybridTank = this.tank;
        return hybridTank instanceof HybridGasTank && (gasTank = (HybridGasTank)hybridTank).canReceiveGas(side, type);
    }

    @Optional.Method(modid="mekanism")
    public boolean canDrawGas(EnumFacing side, Gas type) {
        HybridGasTank gasTank;
        HybridTank hybridTank = this.tank;
        return hybridTank instanceof HybridGasTank && (gasTank = (HybridGasTank)hybridTank).canDrawGas(side, type);
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        GasTankInfo[] gasTankInfoArray;
        HybridTank hybridTank = this.tank;
        if (hybridTank instanceof HybridGasTank) {
            HybridGasTank gasTank = (HybridGasTank)hybridTank;
            gasTankInfoArray = gasTank.getTankInfo();
        } else {
            gasTankInfoArray = NONE;
        }
        return gasTankInfoArray;
    }
}

