/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import github.kasuminova.mmce.common.capability.CapabilityUpgrade;
import github.kasuminova.mmce.common.upgrade.DynamicMachineUpgrade;
import github.kasuminova.mmce.common.upgrade.MachineUpgrade;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import github.kasuminova.mmce.common.upgrade.registry.RegistryUpgrade;
import github.kasuminova.mmce.common.util.BlockPos2ValueMap;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.SelectiveUpdateTileEntity;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntityRestrictedTick;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileUpgradeBus
extends TileEntityRestrictedTick
implements MachineComponentTile,
SelectiveUpdateTileEntity {
    private final UpgradeBusProvider provider = new UpgradeBusProvider();
    private final Map<BlockPos, DynamicMachine> boundedMachine = new BlockPos2ValueMap<DynamicMachine>();
    private final Int2ObjectMap<List<DynamicMachineUpgrade>> foundDynamicUpgrades = new Int2ObjectOpenHashMap();
    private final Map<UpgradeType, MachineUpgrade> foundUpgrades = new HashMap<UpgradeType, MachineUpgrade>();
    private NBTTagCompound upgradeCustomData = new NBTTagCompound();
    private IOInventory inventory = null;

    public TileUpgradeBus() {
    }

    public TileUpgradeBus(int maxUpgradeSlot) {
        int[] slots = new int[maxUpgradeSlot];
        for (int i = 0; i < maxUpgradeSlot; ++i) {
            slots[i] = i;
        }
        this.inventory = new IOInventory(this, slots, new int[0]);
        this.inventory.setListener(this::onUpgradeInventoryChanged);
    }

    @Override
    public void doRestrictedTick() {
        if (this.field_145850_b.field_72995_K || this.ticksExisted % 20 != 0) {
            return;
        }
        int prevSize = this.boundedMachine.size();
        Iterator<Map.Entry<BlockPos, DynamicMachine>> it = this.boundedMachine.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, DynamicMachine> entry = it.next();
            BlockPos key = entry.getKey();
            DynamicMachine machine = entry.getValue();
            TileEntity te = this.field_145850_b.func_175625_s(key);
            if (!(te instanceof TileMultiblockMachineController)) {
                it.remove();
                continue;
            }
            TileMultiblockMachineController controller = (TileMultiblockMachineController)te;
            if (machine.equals(controller.getFoundMachine())) continue;
            it.remove();
        }
        if (prevSize != this.boundedMachine.size()) {
            this.markNoUpdate();
        }
    }

    public synchronized void onUpgradeInventoryChanged(int changedSlot) {
        this.foundUpgrades.clear();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) {
                this.removeDynamicUpgrades(i);
                continue;
            }
            if (!RegistryUpgrade.supportsUpgrade(stackInSlot)) {
                this.removeDynamicUpgrades(i);
                continue;
            }
            CapabilityUpgrade capability = (CapabilityUpgrade)stackInSlot.getCapability(CapabilityUpgrade.MACHINE_UPGRADE_CAPABILITY, null);
            if (capability == null) {
                this.removeDynamicUpgrades(i);
                continue;
            }
            List<MachineUpgrade> upgrades = capability.getUpgrades();
            this.updateUpgrades(upgrades, stackInSlot);
            if (changedSlot != i && changedSlot != -1) continue;
            this.updateDynamicUpgrades(upgrades, stackInSlot, i);
        }
    }

    public void removeDynamicUpgrades(int slotID) {
        List removed = (List)this.foundDynamicUpgrades.remove(slotID);
        if (removed != null) {
            for (DynamicMachineUpgrade dynamicUpgrade : removed) {
                dynamicUpgrade.invalidate();
            }
        }
    }

    public void updateDynamicUpgrades(List<MachineUpgrade> upgrades, ItemStack parentStack, int slotID) {
        this.foundDynamicUpgrades.put(slotID, (Object)upgrades.stream().filter(DynamicMachineUpgrade.class::isInstance).map(DynamicMachineUpgrade.class::cast).map(dynamicUpgrade -> dynamicUpgrade.setParentBus(this).setParentStack(parentStack).setBusInventoryIndex(slotID)).collect(Collectors.toCollection(LinkedList::new)));
    }

    public void updateUpgrades(List<MachineUpgrade> upgrades, ItemStack parentStack) {
        for (MachineUpgrade upgrade : upgrades) {
            if (upgrade instanceof DynamicMachineUpgrade) continue;
            UpgradeType type = upgrade.getType();
            MachineUpgrade founded = this.foundUpgrades.get(type);
            if (founded != null) {
                founded.incrementStackSize(upgrade.getStackSize());
                continue;
            }
            upgrade.incrementStackSize(parentStack.func_190916_E() - 1);
            this.foundUpgrades.put(type, upgrade.setParentBus(this));
        }
    }

    public IOInventory getInventory() {
        return this.inventory;
    }

    public Map<BlockPos, DynamicMachine> getBoundedMachine() {
        return this.boundedMachine;
    }

    @Override
    @Nonnull
    public UpgradeBusProvider provideComponent() {
        return this.provider;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        if (compound.func_74764_b("inv")) {
            this.inventory = IOInventory.deserialize(this, compound.func_74775_l("inv"));
            this.inventory.setListener(this::onUpgradeInventoryChanged);
        } else {
            this.inventory.clear();
        }
        if (compound.func_74764_b("upgradeCustomData")) {
            this.upgradeCustomData = compound.func_74775_l("upgradeCustomData");
        }
        this.boundedMachine.clear();
        if (compound.func_150297_b("boundedMachine", 9)) {
            NBTTagList tagList = compound.func_150295_c("boundedMachine", 10);
            IntStream.range(0, tagList.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)tagList).func_150305_b(arg_0)).forEach(tagCompound -> {
                BlockPos pos = BlockPos.func_177969_a((long)tagCompound.func_74763_f("pos"));
                DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation(tagCompound.func_74779_i("machine")));
                if (machine == null) {
                    return;
                }
                this.boundedMachine.put(pos, machine);
            });
        }
        this.onUpgradeInventoryChanged(-1);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("inv", (NBTBase)this.inventory.writeNBT());
        compound.func_74782_a("upgradeCustomData", (NBTBase)this.upgradeCustomData);
        if (!this.boundedMachine.isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            this.boundedMachine.forEach((pos, machine) -> {
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74772_a("pos", pos.func_177986_g());
                tagCompound.func_74778_a("machine", machine.getRegistryName().toString());
                tagList.func_74742_a((NBTBase)tagCompound);
            });
            compound.func_74782_a("boundedMachine", (NBTBase)tagList);
        }
    }

    public class UpgradeBusProvider
    extends MachineComponent<UpgradeBusProvider> {
        public UpgradeBusProvider() {
            super(IOType.INPUT);
        }

        public void boundMachine(TileMultiblockMachineController controller) {
            BlockPos pos = controller.func_174877_v();
            DynamicMachine foundMachine = controller.getFoundMachine();
            if (TileUpgradeBus.this.boundedMachine.containsKey(pos) || foundMachine == null) {
                return;
            }
            TileUpgradeBus.this.boundedMachine.put(pos, foundMachine);
            TileUpgradeBus.this.markNoUpdateSync();
        }

        public Map<BlockPos, DynamicMachine> getBoundedMachine() {
            return TileUpgradeBus.this.boundedMachine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<UpgradeType, List<MachineUpgrade>> getUpgrades(@Nullable TileMultiblockMachineController controller) {
            DynamicMachine foundMachine = controller == null ? null : controller.getFoundMachine();
            HashMap<UpgradeType, List<MachineUpgrade>> compatible = new HashMap<UpgradeType, List<MachineUpgrade>>();
            TileUpgradeBus tileUpgradeBus = TileUpgradeBus.this;
            synchronized (tileUpgradeBus) {
                TileUpgradeBus.this.foundUpgrades.forEach((type, upgrade) -> {
                    if (foundMachine == null || type.isCompatible(foundMachine)) {
                        compatible.computeIfAbsent((UpgradeType)type, v -> new LinkedList()).add(upgrade);
                    }
                });
                TileUpgradeBus.this.foundDynamicUpgrades.values().forEach(dynamicUpgrades -> {
                    for (DynamicMachineUpgrade dynamicUpgrade : dynamicUpgrades) {
                        UpgradeType type = dynamicUpgrade.getType();
                        if (foundMachine != null && !type.isCompatible(foundMachine)) continue;
                        compatible.computeIfAbsent(type, v -> new LinkedList()).add(dynamicUpgrade);
                    }
                });
            }
            return compatible;
        }

        public NBTTagCompound getUpgradeCustomData(MachineUpgrade upgrade) {
            return TileUpgradeBus.this.upgradeCustomData.func_74775_l(upgrade.getType().getName());
        }

        public void setUpgradeCustomData(MachineUpgrade upgrade, NBTTagCompound tagCompound) {
            TileUpgradeBus.this.upgradeCustomData.func_74782_a(upgrade.getType().getName(), (NBTBase)tagCompound);
            TileUpgradeBus.this.markNoUpdateSync();
        }

        public int size() {
            return TileUpgradeBus.this.inventory.getSlots();
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_UPGRADE_BUS;
        }

        @Override
        public UpgradeBusProvider getContainerProvider() {
            return this;
        }
    }
}

