/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import github.kasuminova.mmce.common.event.machine.SmartInterfaceUpdateEvent;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.SelectiveUpdateTileEntity;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntityRestrictedTick;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class TileSmartInterface
extends TileEntityRestrictedTick
implements MachineComponentTile,
SelectiveUpdateTileEntity {
    private final List<SmartInterfaceData> boundData = new ArrayList<SmartInterfaceData>();
    private final SmartInterfaceProvider provider = new SmartInterfaceProvider(this);

    @Override
    @Nonnull
    public SmartInterfaceProvider provideComponent() {
        return this.provider;
    }

    @Override
    public void doRestrictedTick() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.ticksExisted % 20 != 0) {
            return;
        }
        if (this.boundData.isEmpty()) {
            return;
        }
        int prevDataSize = this.boundData.size();
        for (int i = 0; i < this.boundData.size(); ++i) {
            TileEntity tileEntity;
            BlockPos pos = this.boundData.get(i).getPos();
            if (!this.func_145831_w().func_175667_e(pos) || (tileEntity = this.func_145831_w().func_175625_s(pos)) instanceof TileMultiblockMachineController) continue;
            this.boundData.remove(i);
            --i;
        }
        if (this.boundData.size() != prevDataSize) {
            this.markForUpdate();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.boundData.clear();
        if (!compound.func_74764_b("boundData")) {
            return;
        }
        NBTTagList tagList = compound.func_150295_c("boundData", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound subCompound = tagList.func_150305_b(i);
            this.boundData.add(SmartInterfaceData.deserialize(subCompound));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        NBTTagList tagList = new NBTTagList();
        for (SmartInterfaceData data : this.boundData) {
            tagList.func_74742_a((NBTBase)data.serialize());
        }
        if (!tagList.func_82582_d()) {
            compound.func_74782_a("boundData", (NBTBase)tagList);
        }
    }

    public static void onDataUpdate(TileSmartInterface owner, SmartInterfaceData newData) {
        TileEntity te = owner.func_145831_w().func_175625_s(newData.getPos());
        if (!(te instanceof TileMultiblockMachineController)) {
            return;
        }
        TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
        new SmartInterfaceUpdateEvent(ctrl, owner.func_174877_v(), newData).postEvent();
    }

    public static class SmartInterfaceProvider
    extends MachineComponent<SmartInterfaceProvider> {
        private final TileSmartInterface parent;
        private final List<SmartInterfaceData> boundData;

        public SmartInterfaceProvider(TileSmartInterface parent) {
            super(IOType.INPUT);
            this.parent = parent;
            this.boundData = parent.boundData;
        }

        @Nullable
        public SmartInterfaceData getMachineData(String type) {
            for (SmartInterfaceData data : this.boundData) {
                if (!data.getType().equals(type)) continue;
                return data;
            }
            return null;
        }

        @Nullable
        public SmartInterfaceData getMachineData(BlockPos pos) {
            for (SmartInterfaceData data : this.boundData) {
                if (!data.getPos().equals((Object)pos)) continue;
                return data;
            }
            return null;
        }

        @Nullable
        public SmartInterfaceData getMachineData(int index) {
            return this.boundData.size() > index ? this.boundData.get(index) : null;
        }

        public void addMachineData(BlockPos pos, ResourceLocation parent, String type, float defaultValue, boolean override) {
            SmartInterfaceData data = this.getMachineData(pos);
            if (data != null) {
                if (override) {
                    this.removeMachineData(pos);
                } else {
                    return;
                }
            }
            SmartInterfaceData newData = new SmartInterfaceData(pos, parent, type, defaultValue);
            this.boundData.add(newData);
            TileSmartInterface.onDataUpdate(this.parent, newData);
            this.parent.markNoUpdateSync();
        }

        public void removeMachineData(BlockPos pos) {
            for (int i = 0; i < this.boundData.size(); ++i) {
                SmartInterfaceData data = this.boundData.get(i);
                if (!data.getPos().equals((Object)pos)) continue;
                this.boundData.remove(i);
                this.parent.markNoUpdateSync();
                return;
            }
        }

        public int getBoundSize() {
            return this.boundData.size();
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_SMART_INTERFACE;
        }

        @Override
        public SmartInterfaceProvider getContainerProvider() {
            return this;
        }
    }
}

