/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class TileParallelController
extends TileColorableMachineComponent
implements MachineComponentTile {
    private final ParallelControllerProvider provider = new ParallelControllerProvider();
    private int maxParallelism = 1;
    private int parallelism = 1;

    public TileParallelController(int maxParallelism) {
        this.maxParallelism = maxParallelism;
        this.parallelism = maxParallelism;
    }

    public TileParallelController() {
    }

    @Override
    @Nonnull
    public ParallelControllerProvider provideComponent() {
        return this.provider;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        if (compound.func_74764_b("maxParallelism")) {
            this.maxParallelism = compound.func_74762_e("maxParallelism");
        }
        if (compound.func_74764_b("parallelism")) {
            this.parallelism = compound.func_74762_e("parallelism");
            if (this.parallelism > this.maxParallelism) {
                this.parallelism = this.maxParallelism;
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("maxParallelism", this.maxParallelism);
        compound.func_74768_a("parallelism", this.parallelism);
    }

    public class ParallelControllerProvider
    extends MachineComponent<ParallelControllerProvider> {
        private ParallelControllerProvider() {
            super(IOType.INPUT);
        }

        public int getParallelism() {
            return TileParallelController.this.parallelism;
        }

        public void setParallelism(int newParallelism) {
            TileParallelController.this.parallelism = newParallelism;
            TileParallelController.this.markForUpdateSync();
        }

        public int getMaxParallelism() {
            return TileParallelController.this.maxParallelism;
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_PARALLEL_CONTROLLER;
        }

        @Override
        public ParallelControllerProvider getContainerProvider() {
            return this;
        }
    }
}

