/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import github.kasuminova.mmce.common.tile.MEPatternProvider;
import github.kasuminova.mmce.common.tile.base.MEItemBus;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.ItemBusSize;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileInventory;
import hellfirepvp.modularmachinery.common.tiles.base.TileItemBus;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemInputBus
extends TileItemBus
implements MachineComponentTile {
    public static int minWorkDelay = 5;
    public static int maxWorkDelay = 60;

    public TileItemInputBus() {
    }

    public TileItemInputBus(ItemBusSize type) {
        super(type);
    }

    @Override
    public void doRestrictedTick() {
        if (this.func_145831_w().field_72995_K || !this.canWork(minWorkDelay, maxWorkDelay)) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            EnumFacing accessingSide;
            IItemHandler itemHandler;
            BlockPos offset = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(offset);
            if (te == null || te instanceof TileItemBus || Mods.AE2.isPresent() && (te instanceof MEItemBus || te instanceof MEPatternProvider) || (itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, accessingSide = facing.func_176734_d())) == null) continue;
            this.inputFromExternal(itemHandler);
        }
    }

    private synchronized void inputFromExternal(IItemHandler external) {
        boolean successAtLeastOnce = false;
        block0: for (int externalSlotId = 0; externalSlotId < external.getSlots(); ++externalSlotId) {
            ItemStack externalStack = external.getStackInSlot(externalSlotId);
            if (externalStack.func_190926_b()) continue;
            for (int internalSlotId = 0; internalSlotId < this.inventory.getSlots(); ++internalSlotId) {
                ItemStack internalStack = this.inventory.getStackInSlot(internalSlotId);
                int maxCanExtract = Math.min(externalStack.func_190916_E(), externalStack.func_77976_d());
                if (internalStack.func_190926_b()) {
                    ItemStack extracted = external.extractItem(externalSlotId, maxCanExtract, false);
                    this.inventory.setStackInSlot(internalSlotId, extracted);
                    successAtLeastOnce = true;
                    if (!external.getStackInSlot(externalSlotId).func_190926_b()) continue;
                    continue block0;
                }
                if (internalStack.func_190916_E() >= internalStack.func_77976_d() || !ItemUtils.matchStacks(internalStack, externalStack)) continue;
                int extractAmt = Math.min(internalStack.func_77976_d() - internalStack.func_190916_E(), maxCanExtract);
                ItemStack extracted = external.extractItem(externalSlotId, extractAmt, false);
                this.inventory.setStackInSlot(internalSlotId, ItemUtils.copyStackWithSize(extracted, internalStack.func_190916_E() + extracted.func_190916_E()));
                successAtLeastOnce = true;
                if (external.getStackInSlot(externalSlotId).func_190926_b()) continue block0;
            }
        }
        if (successAtLeastOnce) {
            this.incrementSuccessCounter(maxWorkDelay, minWorkDelay);
            this.markNoUpdate();
        } else {
            this.decrementSuccessCounter();
        }
    }

    @Override
    public IOInventory buildInventory(TileInventory tile, int size) {
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = i;
        }
        return new IOInventory(tile, slots, new int[0]);
    }

    @Override
    @Nullable
    public MachineComponent.ItemBus provideComponent() {
        return new MachineComponent.ItemBus(IOType.INPUT){

            @Override
            public IOInventory getContainerProvider() {
                return TileItemInputBus.this.inventory;
            }
        };
    }
}

