/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import github.kasuminova.mmce.common.concurrent.FactoryRecipeSearchTask;
import github.kasuminova.mmce.common.concurrent.RecipeCraftingContextPool;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.util.concurrent.SequentialTaskExecutor;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockFactoryController;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import io.netty.util.internal.ThrowableUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TileFactoryController
extends TileMultiblockMachineController {
    private final Map<String, FactoryRecipeThread> coreRecipeThreads = new LinkedHashMap<String, FactoryRecipeThread>();
    private final List<FactoryRecipeThread> recipeThreadList = new LinkedList<FactoryRecipeThread>();
    private final List<ForkJoinTask<?>> waitToExecute = new ArrayList();
    private CraftingStatus controllerStatus = CraftingStatus.MISSING_STRUCTURE;
    private int totalParallelism = 1;
    private int extraThreadCount = 0;
    private BlockFactoryController parentController = null;
    private FactoryRecipeSearchTask searchTask = null;
    private SequentialTaskExecutor threadTask = null;
    private boolean redstoneEffected = false;

    public TileFactoryController() {
    }

    public TileFactoryController(IBlockState state) {
        this();
        if (state.func_177230_c() instanceof BlockFactoryController) {
            this.parentController = (BlockFactoryController)state.func_177230_c();
            this.controllerRotation = (EnumFacing)state.func_177229_b(BlockController.FACING);
            this.parentMachine = this.parentController.getParentMachine();
        } else {
            ModularMachinery.log.warn("Invalid factory controller block at " + this.func_174877_v() + " !");
            this.controllerRotation = EnumFacing.NORTH;
        }
    }

    @Override
    public void doControllerTick() {
        if (this.getStrongPower() > 0) {
            this.redstoneEffected = true;
            return;
        }
        switch (this.workMode) {
            case ASYNC: {
                if (this.executeGroupId == -1L) {
                    this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addTask(() -> {
                        if (this.doAsyncStep()) {
                            return;
                        }
                        this.doSyncStep(false);
                    }, this.timeRecorder.usedTimeAvg());
                    break;
                }
                this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addExecuteGroupTask(() -> {
                    if (this.doAsyncStep()) {
                        return;
                    }
                    this.doSyncStep(false);
                }, this.executeGroupId);
                break;
            }
            case SEMI_SYNC: {
                if (this.executeGroupId == -1L) {
                    this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addTask(() -> {
                        if (this.doAsyncStep()) {
                            return;
                        }
                        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> this.doSyncStep(true));
                    }, this.timeRecorder.usedTimeAvg());
                    break;
                }
                this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addExecuteGroupTask(() -> {
                    if (this.doAsyncStep()) {
                        return;
                    }
                    ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> this.doSyncStep(true));
                }, this.executeGroupId);
                break;
            }
            case SYNC: {
                this.tickExecutor = null;
                if (this.doAsyncStep()) {
                    return;
                }
                this.doSyncStep(false);
            }
        }
    }

    protected boolean doAsyncStep() {
        return !this.doStructureCheck() || !this.isStructureFormed();
    }

    protected void doSyncStep(boolean recordTime) {
        long tickStart = recordTime ? System.nanoTime() : 0L;
        this.onMachineTick(Phase.START);
        boolean prevWorkingStatus = this.isWorking();
        this.executeSeqTask();
        if (this.hasIdleThread()) {
            this.searchAndStartRecipe();
        }
        this.updateCoreThread();
        if (!this.coreRecipeThreads.isEmpty() || !this.recipeThreadList.isEmpty()) {
            this.doRecipeTick();
            this.markNoUpdateSync();
        }
        this.searchRecipeImmediately = false;
        boolean workingStatus = this.isWorking();
        if (prevWorkingStatus != workingStatus) {
            this.updateStatedMachineComponentSync(workingStatus);
        }
        this.onMachineTick(Phase.END);
        if (recordTime) {
            this.timeRecorder.incrementUsedTime((int)TimeUnit.MICROSECONDS.convert(System.nanoTime() - tickStart, TimeUnit.NANOSECONDS));
        }
    }

    @Override
    public CraftingStatus getControllerStatus() {
        return this.controllerStatus;
    }

    @Override
    public void setControllerStatus(CraftingStatus status) {
        this.controllerStatus = status;
    }

    @Override
    public int currentRecipeSearchDelay() {
        if (this.coreRecipeThreads.isEmpty()) {
            return super.currentRecipeSearchDelay();
        }
        return Math.min(20 + this.recipeResearchRetryCounter * Math.max(10 / this.coreRecipeThreads.size(), 1), 150);
    }

    protected void doRecipeTick() {
        this.cleanIdleTimeoutThread();
        for (FactoryRecipeThread thread : this.coreRecipeThreads.values()) {
            if (thread.getActiveRecipe() == null) {
                thread.searchAndStartRecipe();
            }
            this.doThreadRecipeTick(thread);
        }
        for (FactoryRecipeThread thread : this.recipeThreadList) {
            this.doThreadRecipeTick(thread);
        }
    }

    protected void doThreadRecipeTick(FactoryRecipeThread thread) {
        ActiveMachineRecipe activeRecipe = thread.getActiveRecipe();
        if (activeRecipe == null) {
            ++thread.idleTime;
            return;
        }
        if (thread.isWaitForFinish()) {
            if (this.ticksExisted % 10 == 0) {
                thread.onFinished();
            }
            return;
        }
        if (thread.getContext() == null) {
            thread.setContext(thread.createContext(activeRecipe));
        }
        CraftingStatus status = thread.getStatus();
        FactoryRecipeTickEvent event = new FactoryRecipeTickEvent(thread, this, Phase.START);
        event.postEvent();
        if (event.isFailure()) {
            return;
        }
        if (status != thread.getStatus()) {
            status = thread.getStatus();
            thread.onTick();
            thread.setStatus(status);
        } else {
            status = thread.onTick();
        }
        if (this.isNotWorking(thread, status)) {
            if (enableFullDataSync) {
                this.markForUpdateSync();
            } else {
                this.markNoUpdateSync();
            }
            return;
        }
        new FactoryRecipeTickEvent(thread, this, Phase.END).postEvent();
        if (thread.isCompleted()) {
            thread.onFinished();
        }
    }

    protected boolean isNotWorking(FactoryRecipeThread thread, CraftingStatus status) {
        if (status.isCrafting()) {
            return false;
        }
        boolean destruct = this.onThreadRecipeFailure(thread);
        if (destruct) {
            thread.setActiveRecipe(null).setContext(null).getSemiPermanentModifiers().clear();
        }
        return true;
    }

    public void onThreadRecipeStart(FactoryRecipeThread thread) {
        new FactoryRecipeStartEvent(thread, this).postEvent();
        ActiveMachineRecipe activeRecipe = thread.getActiveRecipe();
        activeRecipe.start(thread.getContext());
        this.resetRecipeSearchRetryCount();
        if (enableFullDataSync) {
            this.markForUpdateSync();
        } else {
            this.markNoUpdateSync();
        }
    }

    public boolean onThreadRecipeFailure(FactoryRecipeThread thread) {
        ActiveMachineRecipe activeRecipe = thread.getActiveRecipe();
        if (activeRecipe == null) {
            return false;
        }
        MachineRecipe recipe = activeRecipe.getRecipe();
        FactoryRecipeFailureEvent event = new FactoryRecipeFailureEvent(thread, this, thread.getStatus().getUnlocMessage(), recipe.doesCancelRecipeOnPerTickFailure());
        event.postEvent();
        return event.isDestructRecipe();
    }

    public void onThreadRecipeFinished(FactoryRecipeThread thread) {
        new FactoryRecipeFinishEvent(thread, this).postEvent();
        if (enableFullDataSync) {
            this.markForUpdateSync();
        } else {
            this.markNoUpdateSync();
        }
    }

    @Override
    protected void onStructureFormed() {
        super.onStructureFormed();
        this.coreRecipeThreads.clear();
        this.foundMachine.getCoreThreadPreset().forEach((threadName, thread) -> this.coreRecipeThreads.put((String)threadName, thread.copyCoreThread(this)));
    }

    protected void searchAndStartRecipe() {
        if (this.searchTask != null) {
            FactoryRecipeSearchTask task = this.searchTask;
            if (!task.isDone()) {
                return;
            }
            this.timeRecorder.addRecipeResearchUsedTime(this.searchTask.usedTime);
            RecipeCraftingContext context = null;
            try {
                context = (RecipeCraftingContext)task.get();
            }
            catch (Exception e) {
                ModularMachinery.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
            }
            if (context != null) {
                if (context.canStartCrafting().isSuccess()) {
                    this.offerRecipe(context);
                    if (this.hasIdleThread()) {
                        this.createRecipeSearchTask();
                    }
                } else {
                    RecipeCraftingContextPool.returnCtx(context);
                }
            } else {
                this.incrementRecipeSearchRetryCount();
                CraftingStatus status = task.getStatus();
                if (status != null && !this.controllerStatus.equals(status)) {
                    this.controllerStatus = status;
                    this.markNoUpdateSync();
                }
            }
            this.searchTask = null;
        } else if (this.searchRecipeImmediately || this.ticksExisted % this.currentRecipeSearchDelay() == 0) {
            this.createRecipeSearchTask();
        }
    }

    protected void executeSeqTask() {
        if (this.threadTask != null ? !this.threadTask.isDone() || this.waitToExecute.isEmpty() : this.waitToExecute.isEmpty()) {
            return;
        }
        this.threadTask = new SequentialTaskExecutor(this.waitToExecute);
        this.waitToExecute.clear();
        ModularMachinery.EXECUTE_MANAGER.submitForkJoinTask(this.threadTask);
    }

    @Override
    protected void resetMachine(boolean clearData) {
        super.resetMachine(clearData);
        if (clearData) {
            this.recipeThreadList.clear();
            this.coreRecipeThreads.clear();
            this.extraThreadCount = 0;
        }
    }

    public List<FactoryRecipeThread> getFactoryRecipeThreadList() {
        return this.recipeThreadList;
    }

    public Map<String, FactoryRecipeThread> getCoreRecipeThreads() {
        return this.coreRecipeThreads;
    }

    public int getAvailableParallelism() {
        ActiveMachineRecipe activeRecipe;
        int maxParallelism = this.getMaxParallelism();
        for (FactoryRecipeThread thread : this.recipeThreadList) {
            activeRecipe = thread.getActiveRecipe();
            if (activeRecipe == null) continue;
            maxParallelism -= activeRecipe.getParallelism() - 1;
        }
        for (FactoryRecipeThread thread : this.coreRecipeThreads.values()) {
            activeRecipe = thread.getActiveRecipe();
            if (activeRecipe == null) continue;
            maxParallelism -= activeRecipe.getParallelism() - 1;
        }
        return Math.max(1, maxParallelism);
    }

    public int getTotalParallelism() {
        return this.totalParallelism;
    }

    public List<ForkJoinTask<?>> getWaitToExecute() {
        return this.waitToExecute;
    }

    public void offerRecipe(RecipeCraftingContext context) {
        for (FactoryRecipeThread thread : this.recipeThreadList) {
            if (thread.getActiveRecipe() != null) continue;
            thread.setContext(context).setActiveRecipe(context.getActiveRecipe()).setStatus(CraftingStatus.SUCCESS);
            this.onThreadRecipeStart(thread);
            return;
        }
        if (this.recipeThreadList.size() > this.getMaxThreads()) {
            return;
        }
        FactoryRecipeThread thread = new FactoryRecipeThread(this);
        thread.setContext(context).setActiveRecipe(context.getActiveRecipe()).setStatus(CraftingStatus.SUCCESS);
        this.recipeThreadList.add(thread);
        this.onThreadRecipeStart(thread);
    }

    public int getMaxThreads() {
        return this.extraThreadCount + this.foundMachine.getMaxThreads();
    }

    @Override
    public void flushContextModifier() {
        this.recipeThreadList.forEach(RecipeThread::flushContextModifier);
    }

    protected void createRecipeSearchTask() {
        this.searchTask = new FactoryRecipeSearchTask(this, this.getFoundMachine(), this.getAvailableParallelism(), RecipeRegistry.getRecipesFor(this.foundMachine), null, this.getActiveRecipeList());
        this.waitToExecute.add(this.searchTask);
    }

    protected void updateCoreThread() {
        Map<String, FactoryRecipeThread> threads = this.foundMachine.getCoreThreadPreset();
        if (threads.isEmpty()) {
            this.coreRecipeThreads.clear();
            return;
        }
        if (!this.coreRecipeThreads.isEmpty() && this.ticksExisted % 20 != 0) {
            return;
        }
        threads.forEach((name, thread) -> {
            if (!this.coreRecipeThreads.containsKey(name)) {
                this.coreRecipeThreads.put((String)name, thread.copyCoreThread(this));
            }
        });
        Iterator<Map.Entry<String, FactoryRecipeThread>> it = this.coreRecipeThreads.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, FactoryRecipeThread> threadEntry = it.next();
            String name2 = threadEntry.getKey();
            FactoryRecipeThread thread2 = threads.get(name2);
            if (thread2 == null) {
                it.remove();
                continue;
            }
            FactoryRecipeThread factoryThread = threadEntry.getValue();
            TreeSet<MachineRecipe> recipeSet = factoryThread.getRecipeSet();
            recipeSet.clear();
            recipeSet.addAll(thread2.getRecipeSet());
        }
    }

    protected void cleanIdleTimeoutThread() {
        if (this.ticksExisted % 20 != 0) {
            return;
        }
        this.recipeThreadList.removeIf(thread -> thread.isIdle() && thread.idleTime >= 200);
    }

    public boolean hasIdleThread() {
        if (this.recipeThreadList.size() < this.getMaxThreads()) {
            return true;
        }
        for (FactoryRecipeThread thread : this.recipeThreadList) {
            if (thread.getActiveRecipe() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updateComponents() {
        RecipeCraftingContext ctx;
        super.updateComponents();
        for (FactoryRecipeThread thread : this.recipeThreadList) {
            ctx = thread.getContext();
            if (ctx == null) continue;
            ctx.updateComponents(this.foundComponents.values());
        }
        for (FactoryRecipeThread thread : this.coreRecipeThreads.values()) {
            ctx = thread.getContext();
            if (ctx == null) continue;
            ctx.updateComponents(this.foundComponents.values());
        }
    }

    @Override
    protected boolean canCheckStructure() {
        if (this.redstoneEffected) {
            this.redstoneEffected = false;
            return true;
        }
        return super.canCheckStructure();
    }

    @Override
    protected void checkRotation() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockFactoryController) {
            this.parentController = (BlockFactoryController)state.func_177230_c();
            this.parentMachine = this.parentController.getParentMachine();
            this.controllerRotation = (EnumFacing)state.func_177229_b(BlockController.FACING);
        } else {
            ModularMachinery.log.warn("Invalid factory controller block at " + this.func_174877_v() + " !");
            this.controllerRotation = EnumFacing.NORTH;
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        FactoryRecipeThread thread;
        NBTTagCompound tagAt;
        int i;
        NBTTagList threadList;
        super.readCustomNBT(compound);
        if (!this.isStructureFormed()) {
            return;
        }
        this.parentController = BlockFactoryController.FACTORY_CONTROLLERS.get(this.parentMachine);
        if (compound.func_74764_b("status")) {
            this.controllerStatus = CraftingStatus.deserialize(compound.func_74775_l("status"));
        }
        this.extraThreadCount = compound.func_74771_c("extraThreadCount");
        this.recipeThreadList.clear();
        this.coreRecipeThreads.clear();
        if (compound.func_150297_b("threadList", 9)) {
            threadList = compound.func_150295_c("threadList", 10);
            for (i = 0; i < threadList.func_74745_c(); ++i) {
                tagAt = threadList.func_150305_b(i);
                thread = FactoryRecipeThread.deserialize(tagAt, this);
                if (thread == null) continue;
                this.recipeThreadList.add(thread);
            }
        }
        if (compound.func_150297_b("coreThreadList", 9)) {
            threadList = compound.func_150295_c("coreThreadList", 10);
            for (i = 0; i < threadList.func_74745_c(); ++i) {
                tagAt = threadList.func_150305_b(i);
                thread = FactoryRecipeThread.deserialize(tagAt, this);
                if (thread == null) continue;
                this.coreRecipeThreads.put(thread.getThreadName(), thread);
            }
        }
        if (compound.func_74764_b("totalParallelism")) {
            this.totalParallelism = compound.func_74762_e("totalParallelism");
        }
    }

    @Override
    protected void readMachineNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("parentMachine")) {
            ResourceLocation rl = new ResourceLocation(compound.func_74779_i("parentMachine"));
            this.parentMachine = MachineRegistry.getRegistry().getMachine(rl);
            if (this.parentMachine != null) {
                this.parentController = BlockFactoryController.FACTORY_CONTROLLERS.get(this.parentMachine);
            } else {
                ModularMachinery.log.info("Couldn't find machine named " + rl + " for controller at " + this.func_174877_v());
            }
        }
        super.readMachineNBT(compound);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        NBTTagList threadList;
        super.writeCustomNBT(compound);
        if (!this.isStructureFormed()) {
            return;
        }
        if (!this.recipeThreadList.isEmpty()) {
            threadList = new NBTTagList();
            this.recipeThreadList.forEach(thread -> threadList.func_74742_a((NBTBase)thread.serialize()));
            compound.func_74782_a("threadList", (NBTBase)threadList);
        }
        if (!this.coreRecipeThreads.isEmpty()) {
            threadList = new NBTTagList();
            this.coreRecipeThreads.values().forEach(thread -> threadList.func_74742_a((NBTBase)thread.serialize()));
            compound.func_74782_a("coreThreadList", (NBTBase)threadList);
        }
        compound.func_74782_a("status", (NBTBase)this.controllerStatus.serialize());
        compound.func_74768_a("totalParallelism", this.getMaxParallelism());
        compound.func_74777_a("extraThreadCount", (short)this.extraThreadCount);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (FactoryRecipeThread thread : this.recipeThreadList) {
            thread.invalidate();
        }
        this.recipeThreadList.clear();
        for (FactoryRecipeThread thread : this.coreRecipeThreads.values()) {
            thread.invalidate();
        }
        this.coreRecipeThreads.clear();
    }

    @Override
    @Nullable
    public ActiveMachineRecipe getActiveRecipe() {
        ActiveMachineRecipe[] activeRecipes = this.getActiveRecipeList();
        return activeRecipes.length == 0 ? null : activeRecipes[0];
    }

    @Override
    @Nonnull
    public ActiveMachineRecipe[] getActiveRecipeList() {
        ActiveMachineRecipe activeRecipe;
        ArrayList<ActiveMachineRecipe> list = new ArrayList<ActiveMachineRecipe>();
        for (FactoryRecipeThread thread : this.coreRecipeThreads.values()) {
            activeRecipe = thread.getActiveRecipe();
            if (activeRecipe == null) continue;
            list.add(activeRecipe);
        }
        for (FactoryRecipeThread thread : this.recipeThreadList) {
            activeRecipe = thread.getActiveRecipe();
            if (activeRecipe == null) continue;
            list.add(activeRecipe);
        }
        return list.toArray(new ActiveMachineRecipe[0]);
    }

    @Override
    public RecipeThread[] getRecipeThreadList() {
        ArrayList<FactoryRecipeThread> list = new ArrayList<FactoryRecipeThread>();
        list.addAll(this.coreRecipeThreads.values());
        list.addAll(this.recipeThreadList);
        return list.toArray(new RecipeThread[0]);
    }

    @Override
    public int getExtraThreadCount() {
        return this.extraThreadCount;
    }

    @Override
    public void setExtraThreadCount(int extraThreadCount) {
        this.extraThreadCount = extraThreadCount;
    }

    @Override
    public boolean isWorking() {
        if (this.lastStrongPower > 0) {
            return false;
        }
        if (this.coreRecipeThreads.isEmpty() && this.recipeThreadList.isEmpty()) {
            return false;
        }
        for (FactoryRecipeThread thread : this.coreRecipeThreads.values()) {
            if (thread.getActiveRecipe() == null || !thread.getStatus().isCrafting()) continue;
            return true;
        }
        for (FactoryRecipeThread thread : this.recipeThreadList) {
            if (thread.getActiveRecipe() == null || !thread.getStatus().isCrafting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addModifier(String key, RecipeModifier modifier) {
        this.coreRecipeThreads.values().forEach(thread -> thread.addModifier(key, modifier));
        this.recipeThreadList.forEach(thread -> thread.addModifier(key, modifier));
    }

    @Override
    public void removeModifier(String key) {
        this.coreRecipeThreads.values().forEach(thread -> thread.removeModifier(key));
        this.recipeThreadList.forEach(thread -> thread.removeModifier(key));
    }

    @Override
    @Deprecated
    public void overrideStatusInfo(String newInfo) {
    }
}

