/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import cofh.redstoneflux.api.IEnergyConnection;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.api.IEnergyStorage;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.EnergyHatchData;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.integration.IntegrationIC2EventHandlerHelper;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerAsync;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")
public class TileEnergyOutputHatch
extends TileEnergyHatch
implements IEnergySource {
    public TileEnergyOutputHatch() {
    }

    public TileEnergyOutputHatch(EnergyHatchData size) {
        super(size, IOType.OUTPUT);
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.tickedOnce) {
            if (Mods.IC2.isPresent()) {
                IntegrationIC2EventHandlerHelper.onEnergyTileLoaded(this);
            }
            this.tickedOnce = true;
        }
        long prevEnergy = this.energy.get();
        long maxCanExtract = Math.min(this.size.transferLimit, this.energy.get());
        if (maxCanExtract <= 0L) {
            return;
        }
        if (Mods.DRACONICEVOLUTION.isPresent() && EnergyHatchData.enableDEIntegration) {
            long transferred = this.attemptDECoreTransfer(maxCanExtract);
            maxCanExtract -= transferred;
            this.energy.addAndGet(-transferred);
        }
        long usableAmps = Mods.GREGTECH.isPresent() ? Math.min((long)this.size.getGtAmperage(), maxCanExtract / 4L / this.size.getGTEnergyTransferVoltage()) : 0L;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (maxCanExtract > 0L && Mods.FLUX_NETWORKS.isPresent() && Config.enableFluxNetworksIntegration) {
                long transferred = this.attemptFluxNetworksTransfer(face, maxCanExtract);
                this.energy.addAndGet(-transferred);
                maxCanExtract -= transferred;
            }
            if (maxCanExtract > 0L && Mods.GREGTECH.isPresent() && usableAmps > 0L) {
                long totalTransferred = this.attemptGTTransfer(face, maxCanExtract / 4L, usableAmps) * 4L;
                usableAmps -= totalTransferred / 4L / this.size.getGTEnergyTransferVoltage();
                maxCanExtract -= totalTransferred;
                this.energy.addAndGet(-totalTransferred);
            }
            if (maxCanExtract > 0L) {
                int transferred = Mods.REDSTONEFLUXAPI.isPresent() ? this.attemptFERFTransfer(face, TileEnergyOutputHatch.convertDownEnergy(maxCanExtract)) : this.attemptFETransfer(face, TileEnergyOutputHatch.convertDownEnergy(maxCanExtract));
                maxCanExtract -= (long)transferred;
                this.energy.addAndGet(-transferred);
            }
            if (maxCanExtract <= 0L) break;
        }
        if (prevEnergy != this.energy.get()) {
            this.markNoUpdateSync();
        }
    }

    @Optional.Method(modid="fluxnetworks")
    protected long attemptFluxNetworksTransfer(EnumFacing face, long maxCanExtract) {
        BlockPos at = this.func_174877_v().func_177972_a(face);
        EnumFacing oppositeSide = face.func_176734_d();
        TileEntity te = this.field_145850_b.func_175625_s(at);
        if (te instanceof TileFluxPlug) {
            TileFluxPlug plug = (TileFluxPlug)te;
            long maxCanReceive = Math.min(plug.getMaxTransferLimit() - plug.getTransferBuffer(), maxCanExtract);
            return plug.getTransferHandler().receiveFromSupplier(maxCanReceive, oppositeSide, false);
        }
        return 0L;
    }

    @Override
    @Optional.Method(modid="draconicevolution")
    protected long attemptDECoreTransfer(long maxCanExtract) {
        TileEntity te;
        TileEntity tileEntity = te = this.foundCore == null ? null : this.field_145850_b.func_175625_s(this.foundCore);
        if (this.foundCore == null || !(te instanceof TileEnergyStorageCore)) {
            this.foundCore = null;
            this.findCore();
        }
        if (this.foundCore != null && te instanceof TileEnergyStorageCore) {
            TileEnergyStorageCore core = (TileEnergyStorageCore)te;
            long energyReceived = Math.min(core.getExtendedCapacity() - core.energy.value, maxCanExtract);
            core.energy.value += energyReceived;
            return energyReceived;
        }
        return 0L;
    }

    @Optional.Method(modid="gregtech")
    private long attemptGTTransfer(EnumFacing face, long transferCap, long usedAmps) {
        IEnergyContainer energyContainer;
        long voltage = this.size.getGTEnergyTransferVoltage();
        long amperes = Math.min(usedAmps, (long)this.size.getGtAmperage());
        int transferableAmps = 0;
        while ((long)transferableAmps < amperes && (long)transferableAmps * voltage <= transferCap) {
            ++transferableAmps;
        }
        if (transferableAmps == 0) {
            return 0L;
        }
        TileEntity tileEntity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
        EnumFacing oppositeSide = face.func_176734_d();
        if (tileEntity != null && tileEntity.hasCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, oppositeSide) && (energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, oppositeSide)) != null && energyContainer.inputsEnergy(oppositeSide)) {
            return energyContainer.acceptEnergyFromNetwork(oppositeSide, voltage, (long)transferableAmps) * voltage;
        }
        return 0L;
    }

    private int attemptFETransfer(EnumFacing face, int maxTransferLeft) {
        net.minecraftforge.energy.IEnergyStorage ce;
        BlockPos at = this.func_174877_v().func_177972_a(face);
        EnumFacing accessingSide = face.func_176734_d();
        int receivedEnergy = 0;
        TileEntity te = this.field_145850_b.func_175625_s(at);
        if (te != null && !(te instanceof TileEnergyHatch) && te.hasCapability(CapabilityEnergy.ENERGY, accessingSide) && (ce = (net.minecraftforge.energy.IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, accessingSide)) != null && ce.canReceive()) {
            receivedEnergy = ce.receiveEnergy(maxTransferLeft, false);
        }
        return receivedEnergy;
    }

    @Optional.Method(modid="redstoneflux")
    private int attemptFERFTransfer(EnumFacing face, int maxTransferLeft) {
        BlockPos at = this.func_174877_v().func_177972_a(face);
        EnumFacing accessingSide = face.func_176734_d();
        int receivedEnergy = 0;
        TileEntity te = this.field_145850_b.func_175625_s(at);
        if (te != null && !(te instanceof TileEnergyHatch)) {
            net.minecraftforge.energy.IEnergyStorage ce;
            if (te instanceof IEnergyReceiver && ((IEnergyConnection)te).canConnectEnergy(accessingSide)) {
                try {
                    receivedEnergy = ((IEnergyReceiver)te).receiveEnergy(accessingSide, maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (receivedEnergy <= 0 && te instanceof IEnergyStorage) {
                try {
                    receivedEnergy = ((IEnergyStorage)te).receiveEnergy(maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (receivedEnergy <= 0 && te.hasCapability(CapabilityEnergy.ENERGY, accessingSide) && (ce = (net.minecraftforge.energy.IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, accessingSide)) != null && ce.canReceive()) {
                try {
                    receivedEnergy = ce.receiveEnergy(maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return receivedEnergy;
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (Mods.IC2.isPresent() && this.tickedOnce && !this.field_145850_b.field_72995_K) {
            IntegrationIC2EventHandlerHelper.onEnergyTileUnLoaded(this);
        }
    }

    @Optional.Method(modid="ic2")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (Mods.IC2.isPresent() && this.tickedOnce && !this.field_145850_b.field_72995_K) {
            IntegrationIC2EventHandlerHelper.onEnergyTileUnLoaded(this);
        }
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min((long)this.size.getIC2EnergyTransmission(), this.getCurrentEnergy() / 4L);
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.energy.set(MiscUtils.clamp(this.energy.get() - MathHelper.func_76124_d((double)amount) * 4L, 0L, this.size.maxEnergy));
        this.markNoUpdateSync();
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return this.size.ic2EnergyTier;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    @Nullable
    public MachineComponent.EnergyHatch provideComponent() {
        return new MachineComponent.EnergyHatch(IOType.OUTPUT){

            @Override
            public IEnergyHandlerAsync getContainerProvider() {
                return TileEnergyOutputHatch.this;
            }
        };
    }
}

