/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.EnergyHatchData;
import hellfirepvp.modularmachinery.common.integration.IntegrationIC2EventHandlerHelper;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerAsync;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")
public class TileEnergyInputHatch
extends TileEnergyHatch
implements IEnergySink {
    public TileEnergyInputHatch() {
    }

    public TileEnergyInputHatch(EnergyHatchData size) {
        super(size, IOType.INPUT);
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    public void func_73660_a() {
        long received;
        long maxCanReceive;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.tickedOnce) {
            if (Mods.IC2.isPresent()) {
                IntegrationIC2EventHandlerHelper.onEnergyTileLoaded(this);
            }
            this.tickedOnce = true;
        }
        if ((maxCanReceive = Math.min(this.size.transferLimit, this.size.maxEnergy - this.energy.get())) <= 0L) {
            return;
        }
        if (Mods.DRACONICEVOLUTION.isPresent() && EnergyHatchData.enableDEIntegration && (received = this.attemptDECoreTransfer(maxCanReceive)) != 0L) {
            this.energy.addAndGet(received);
            this.markNoUpdateSync();
        }
    }

    @Override
    @Optional.Method(modid="draconicevolution")
    protected long attemptDECoreTransfer(long maxCanReceive) {
        TileEntity te;
        TileEntity tileEntity = te = this.foundCore == null ? null : this.field_145850_b.func_175625_s(this.foundCore);
        if (this.foundCore == null || !(te instanceof TileEnergyStorageCore)) {
            this.foundCore = null;
            this.findCore();
            return 0L;
        }
        TileEnergyStorageCore core = (TileEnergyStorageCore)te;
        long received = Math.min(core.energy.value, maxCanReceive);
        core.energy.value -= received;
        return received;
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (Mods.IC2.isPresent() && this.tickedOnce && !this.field_145850_b.field_72995_K) {
            IntegrationIC2EventHandlerHelper.onEnergyTileUnLoaded(this);
        }
    }

    @Optional.Method(modid="ic2")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (Mods.IC2.isPresent() && this.tickedOnce && !this.field_145850_b.field_72995_K) {
            IntegrationIC2EventHandlerHelper.onEnergyTileUnLoaded(this);
        }
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return Math.min((this.size.maxEnergy - this.energy.get()) / 4L, (long)this.size.getIC2EnergyTransmission());
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return this.size.ic2EnergyTier;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        long addable = Math.min((this.size.maxEnergy - this.energy.get()) / 4L, MathHelper.func_76124_d((double)amount));
        this.energy.set(MiscUtils.clamp(this.energy.get() + MathHelper.func_76124_d((double)(addable * 4L)), 0L, this.size.maxEnergy));
        this.markNoUpdateSync();
        return amount -= (double)addable;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    @Override
    @Nullable
    public MachineComponent.EnergyHatch provideComponent() {
        return new MachineComponent.EnergyHatch(IOType.INPUT){

            @Override
            public IEnergyHandlerAsync getContainerProvider() {
                return TileEnergyInputHatch.this;
            }
        };
    }
}

