/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.registry;

import github.kasuminova.mmce.common.block.appeng.BlockMEFluidInputBus;
import github.kasuminova.mmce.common.block.appeng.BlockMEFluidOutputBus;
import github.kasuminova.mmce.common.block.appeng.BlockMEGasInputBus;
import github.kasuminova.mmce.common.block.appeng.BlockMEGasOutputBus;
import github.kasuminova.mmce.common.block.appeng.BlockMEItemInputBus;
import github.kasuminova.mmce.common.block.appeng.BlockMEItemOutputBus;
import github.kasuminova.mmce.common.block.appeng.BlockMEMachineComponent;
import github.kasuminova.mmce.common.block.appeng.BlockMEPatternProvider;
import github.kasuminova.mmce.common.tile.MEFluidInputBus;
import github.kasuminova.mmce.common.tile.MEFluidOutputBus;
import github.kasuminova.mmce.common.tile.MEGasInputBus;
import github.kasuminova.mmce.common.tile.MEGasOutputBus;
import github.kasuminova.mmce.common.tile.MEItemInputBus;
import github.kasuminova.mmce.common.tile.MEItemOutputBus;
import github.kasuminova.mmce.common.tile.MEPatternProvider;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.BlockCasing;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockCustomName;
import hellfirepvp.modularmachinery.common.block.BlockDynamicColor;
import hellfirepvp.modularmachinery.common.block.BlockEnergyInputHatch;
import hellfirepvp.modularmachinery.common.block.BlockEnergyOutputHatch;
import hellfirepvp.modularmachinery.common.block.BlockFactoryController;
import hellfirepvp.modularmachinery.common.block.BlockFluidInputHatch;
import hellfirepvp.modularmachinery.common.block.BlockFluidOutputHatch;
import hellfirepvp.modularmachinery.common.block.BlockInputBus;
import hellfirepvp.modularmachinery.common.block.BlockMachineComponent;
import hellfirepvp.modularmachinery.common.block.BlockOutputBus;
import hellfirepvp.modularmachinery.common.block.BlockParallelController;
import hellfirepvp.modularmachinery.common.block.BlockSmartInterface;
import hellfirepvp.modularmachinery.common.block.BlockStatedMachineComponent;
import hellfirepvp.modularmachinery.common.block.BlockUpgradeBus;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.MachineBuilder;
import hellfirepvp.modularmachinery.common.item.ItemBlockController;
import hellfirepvp.modularmachinery.common.item.ItemBlockCustomName;
import hellfirepvp.modularmachinery.common.item.ItemBlockMEMachineComponent;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponent;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponentCustomName;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.registry.RegistryItems;
import hellfirepvp.modularmachinery.common.tiles.TileEnergyInputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileEnergyOutputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.TileFluidInputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileFluidOutputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileItemInputBus;
import hellfirepvp.modularmachinery.common.tiles.TileItemOutputBus;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.tiles.TileParallelController;
import hellfirepvp.modularmachinery.common.tiles.TileSmartInterface;
import hellfirepvp.modularmachinery.common.tiles.TileUpgradeBus;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import kport.modularmagic.common.block.BlockAspectProviderInput;
import kport.modularmagic.common.block.BlockAspectProviderOutput;
import kport.modularmagic.common.block.BlockAuraProviderInput;
import kport.modularmagic.common.block.BlockAuraProviderOutput;
import kport.modularmagic.common.block.BlockConstellationProvider;
import kport.modularmagic.common.block.BlockGridProviderInput;
import kport.modularmagic.common.block.BlockGridProviderOutput;
import kport.modularmagic.common.block.BlockImpetusProviderInput;
import kport.modularmagic.common.block.BlockImpetusProviderOutput;
import kport.modularmagic.common.block.BlockLifeEssenceProviderInput;
import kport.modularmagic.common.block.BlockLifeEssenceProviderOutput;
import kport.modularmagic.common.block.BlockManaProviderInput;
import kport.modularmagic.common.block.BlockManaProviderOutput;
import kport.modularmagic.common.block.BlockRainbowProvider;
import kport.modularmagic.common.block.BlockStarlightProviderInput;
import kport.modularmagic.common.block.BlockStarlightProviderOutput;
import kport.modularmagic.common.block.BlockWillProviderInput;
import kport.modularmagic.common.block.BlockWillProviderOutput;
import kport.modularmagic.common.tile.TileAspectProvider;
import kport.modularmagic.common.tile.TileAuraProvider;
import kport.modularmagic.common.tile.TileConstellationProvider;
import kport.modularmagic.common.tile.TileGridProvider;
import kport.modularmagic.common.tile.TileImpetusComponent;
import kport.modularmagic.common.tile.TileLifeEssenceProvider;
import kport.modularmagic.common.tile.TileManaProvider;
import kport.modularmagic.common.tile.TileRainbowProvider;
import kport.modularmagic.common.tile.TileStarlightInput;
import kport.modularmagic.common.tile.TileStarlightOutput;
import kport.modularmagic.common.tile.TileWillProvider;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class RegistryBlocks {
    public static final List<BlockDynamicColor> pendingIBlockColorBlocks = new LinkedList<BlockDynamicColor>();
    private static final List<Block> blockModelRegister = new ArrayList<Block>();

    public static void initialize() {
        RegistryBlocks.registerBlocks();
        if (Mods.RESOURCELOADER.isPresent() || Mods.TX_LOADER.isPresent()) {
            try {
                RegistryBlocks.writeAllCustomControllerModels();
            }
            catch (IOException e) {
                ModularMachinery.log.error("Failed to write controller models", (Throwable)e);
            }
        }
        RegistryBlocks.registerTiles();
        RegistryBlocks.registerBlockModels();
    }

    private static void registerBlocks() {
        BlocksMM.blockController = RegistryBlocks.prepareRegister(new BlockController());
        RegistryBlocks.prepareItemBlockRegister(new ItemBlockController(BlocksMM.blockController));
        BlocksMM.blockFactoryController = RegistryBlocks.prepareRegister(new BlockFactoryController());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockFactoryController);
        RegistryBlocks.registerCustomControllers();
        RegistryBlocks.registerExampleStatedMachineComponent();
        RegistryBlocks.registerCustomStatedMachineComponent();
        BlocksMM.blockCasing = RegistryBlocks.prepareRegister(new BlockCasing());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockCasing);
        BlocksMM.itemInputBus = RegistryBlocks.prepareRegister(new BlockInputBus());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.itemInputBus);
        BlocksMM.itemOutputBus = RegistryBlocks.prepareRegister(new BlockOutputBus());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.itemOutputBus);
        BlocksMM.fluidInputHatch = RegistryBlocks.prepareRegister(new BlockFluidInputHatch());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.fluidInputHatch);
        BlocksMM.fluidOutputHatch = RegistryBlocks.prepareRegister(new BlockFluidOutputHatch());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.fluidOutputHatch);
        BlocksMM.energyInputHatch = RegistryBlocks.prepareRegister(new BlockEnergyInputHatch());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.energyInputHatch);
        BlocksMM.energyOutputHatch = RegistryBlocks.prepareRegister(new BlockEnergyOutputHatch());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.energyOutputHatch);
        BlocksMM.smartInterface = RegistryBlocks.prepareRegister(new BlockSmartInterface());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.smartInterface);
        BlocksMM.parallelController = RegistryBlocks.prepareRegister(new BlockParallelController());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.parallelController);
        BlocksMM.upgradeBus = RegistryBlocks.prepareRegister(new BlockUpgradeBus());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.upgradeBus);
        if (Mods.AE2.isPresent()) {
            BlocksMM.meItemOutputBus = RegistryBlocks.prepareRegister(new BlockMEItemOutputBus());
            ItemsMM.meItemOutputBus = RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.meItemOutputBus);
            BlocksMM.meItemInputBus = RegistryBlocks.prepareRegister(new BlockMEItemInputBus());
            ItemsMM.meItemInputBus = RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.meItemInputBus);
            BlocksMM.meFluidOutputBus = RegistryBlocks.prepareRegister(new BlockMEFluidOutputBus());
            ItemsMM.meFluidOutputBus = RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.meFluidOutputBus);
            BlocksMM.meFluidInputBus = RegistryBlocks.prepareRegister(new BlockMEFluidInputBus());
            ItemsMM.meFluidInputBus = RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.meFluidInputBus);
            if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
                BlocksMM.meGasOutputBus = RegistryBlocks.prepareRegister(new BlockMEGasOutputBus());
                ItemsMM.meGasOutputBus = RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.meGasOutputBus);
                BlocksMM.meGasInputBus = RegistryBlocks.prepareRegister(new BlockMEGasInputBus());
                ItemsMM.meGasInputBus = RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.meGasInputBus);
            }
            BlocksMM.mePatternProvider = RegistryBlocks.prepareRegister(new BlockMEPatternProvider());
            ItemsMM.mePatternProvider = RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.mePatternProvider);
        }
        if (Mods.BM2.isPresent()) {
            BlocksMM.blockWillProviderInput = RegistryBlocks.prepareRegister(new BlockWillProviderInput());
            BlocksMM.blockWillProviderOutput = RegistryBlocks.prepareRegister(new BlockWillProviderOutput());
            BlocksMM.blockLifeEssenceProviderInput = RegistryBlocks.prepareRegister(new BlockLifeEssenceProviderInput());
            BlocksMM.blockLifeEssenceProviderOutput = RegistryBlocks.prepareRegister(new BlockLifeEssenceProviderOutput());
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockWillProviderInput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockWillProviderOutput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockLifeEssenceProviderInput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockLifeEssenceProviderOutput);
        }
        if (Mods.TC6.isPresent()) {
            BlocksMM.blockAspectProviderInput = RegistryBlocks.prepareRegister(new BlockAspectProviderInput());
            BlocksMM.blockAspectProviderOutput = RegistryBlocks.prepareRegister(new BlockAspectProviderOutput());
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockAspectProviderInput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockAspectProviderOutput);
        }
        if (Mods.TA.isPresent()) {
            BlocksMM.blockImpetusProviderInput = RegistryBlocks.prepareRegister(new BlockImpetusProviderInput());
            BlocksMM.blockImpetusProviderOutput = RegistryBlocks.prepareRegister(new BlockImpetusProviderOutput());
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockImpetusProviderInput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockImpetusProviderOutput);
        }
        if (Mods.EXU2.isPresent()) {
            BlocksMM.blockGridProviderInput = RegistryBlocks.prepareRegister(new BlockGridProviderInput());
            BlocksMM.blockGridProviderOutput = RegistryBlocks.prepareRegister(new BlockGridProviderOutput());
            BlocksMM.blockRainbowProvider = RegistryBlocks.prepareRegister(new BlockRainbowProvider());
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockGridProviderInput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockGridProviderOutput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockRainbowProvider);
        }
        if (Mods.ASTRAL_SORCERY.isPresent()) {
            BlocksMM.blockStarlightProviderInput = RegistryBlocks.prepareRegister(new BlockStarlightProviderInput());
            BlocksMM.blockStarlightProviderOutput = RegistryBlocks.prepareRegister(new BlockStarlightProviderOutput());
            BlocksMM.blockConstellationProvider = RegistryBlocks.prepareRegister(new BlockConstellationProvider());
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockStarlightProviderInput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockStarlightProviderOutput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockConstellationProvider);
        }
        if (Mods.NATURESAURA.isPresent()) {
            BlocksMM.blockAuraProviderInput = RegistryBlocks.prepareRegister(new BlockAuraProviderInput());
            BlocksMM.blockAuraProviderOutput = RegistryBlocks.prepareRegister(new BlockAuraProviderOutput());
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockAuraProviderInput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockAuraProviderOutput);
        }
        if (Mods.BOTANIA.isPresent()) {
            BlocksMM.blockManaProviderInput = RegistryBlocks.prepareRegister(new BlockManaProviderInput());
            BlocksMM.blockManaProviderOutput = RegistryBlocks.prepareRegister(new BlockManaProviderOutput());
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockManaProviderInput);
            RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockManaProviderOutput);
        }
    }

    private static void registerTiles() {
        RegistryBlocks.registerTile(TileColorableMachineComponent.class);
        RegistryBlocks.registerTile(TileMachineController.class);
        RegistryBlocks.registerTile(TileFactoryController.class);
        RegistryBlocks.registerTile(TileFluidInputHatch.class);
        RegistryBlocks.registerTile(TileFluidOutputHatch.class);
        RegistryBlocks.registerTile(TileItemOutputBus.class);
        RegistryBlocks.registerTile(TileItemInputBus.class);
        RegistryBlocks.registerTile(TileEnergyInputHatch.class);
        RegistryBlocks.registerTile(TileEnergyOutputHatch.class);
        RegistryBlocks.registerTile(TileSmartInterface.class);
        RegistryBlocks.registerTile(TileParallelController.class);
        RegistryBlocks.registerTile(TileUpgradeBus.class);
        if (Mods.AE2.isPresent()) {
            RegistryBlocks.registerTileWithModID(MEItemOutputBus.class);
            RegistryBlocks.registerTileWithModID(MEItemInputBus.class);
            RegistryBlocks.registerTileWithModID(MEFluidOutputBus.class);
            RegistryBlocks.registerTileWithModID(MEFluidInputBus.class);
            if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
                RegistryBlocks.registerTileWithModID(MEGasOutputBus.class);
                RegistryBlocks.registerTileWithModID(MEGasInputBus.class);
            }
            RegistryBlocks.registerTileWithModID(MEPatternProvider.class);
        }
        if (Mods.BM2.isPresent()) {
            GameRegistry.registerTileEntity(TileWillProvider.Input.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilewillproviderinput"));
            GameRegistry.registerTileEntity(TileWillProvider.Output.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilewillprovideroutput"));
            GameRegistry.registerTileEntity(TileLifeEssenceProvider.Input.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilelifeessenceproviderinput"));
            GameRegistry.registerTileEntity(TileLifeEssenceProvider.Output.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilelifeessenceprovideroutput"));
        }
        if (Mods.TC6.isPresent()) {
            GameRegistry.registerTileEntity(TileAspectProvider.Input.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tileaspectproviderinput"));
            GameRegistry.registerTileEntity(TileAspectProvider.Output.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tileaspectprovideroutput"));
        }
        if (Mods.EXU2.isPresent()) {
            GameRegistry.registerTileEntity(TileGridProvider.Input.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilegridproviderinput"));
            GameRegistry.registerTileEntity(TileGridProvider.Output.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilegridprovideroutput"));
            GameRegistry.registerTileEntity(TileRainbowProvider.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilerainbowprovider"));
        }
        if (Mods.ASTRAL_SORCERY.isPresent()) {
            GameRegistry.registerTileEntity(TileStarlightInput.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilestarlightinput"));
            GameRegistry.registerTileEntity(TileStarlightOutput.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilestarlightoutput"));
            GameRegistry.registerTileEntity(TileConstellationProvider.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tileconstellationprovider"));
        }
        if (Mods.NATURESAURA.isPresent()) {
            GameRegistry.registerTileEntity(TileAuraProvider.Input.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tileauraproviderinput"));
            GameRegistry.registerTileEntity(TileAuraProvider.Output.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tileauraprovideroutput"));
        }
        if (Mods.BOTANIA.isPresent()) {
            GameRegistry.registerTileEntity(TileManaProvider.Input.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilemanainput"));
            GameRegistry.registerTileEntity(TileManaProvider.Output.class, (ResourceLocation)new ResourceLocation("modularmachinery", "tilemanaoutput"));
        }
        if (Mods.TA.isPresent()) {
            GameRegistry.registerTileEntity(TileImpetusComponent.Input.class, (ResourceLocation)new ResourceLocation("modularmachinery", "impetusinput"));
            GameRegistry.registerTileEntity(TileImpetusComponent.Output.class, (ResourceLocation)new ResourceLocation("modularmachinery", "impetusoutput"));
        }
    }

    private static void registerExampleStatedMachineComponent() {
        RegistryBlocks.registerStatedMachineComponent((BlockStatedMachineComponent)new BlockStatedMachineComponent().setRegistryName("crushing_wheels"));
    }

    private static void registerCustomStatedMachineComponent() {
        for (BlockStatedMachineComponent block : BlockStatedMachineComponent.WAIT_FOR_REGISTRY) {
            RegistryBlocks.registerStatedMachineComponent(block);
        }
        BlockStatedMachineComponent.WAIT_FOR_REGISTRY.clear();
    }

    public static void registerStatedMachineComponent(BlockStatedMachineComponent block) {
        RegistryBlocks.prepareRegisterWithCustomName(block);
        ItemBlockCustomName itemBlock = new ItemBlockCustomName((Block)block){

            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public String func_77653_i(@Nonnull ItemStack stack) {
                return this.field_150939_a.func_149732_F();
            }
        };
        itemBlock.setRegistryName(block.getRegistryName());
        RegistryBlocks.prepareItemBlockRegisterWithCustomName(itemBlock);
    }

    private static void registerCustomControllers() {
        ItemBlockController ctrlBlockItem;
        BlockController ctrlBlock;
        if (Config.onlyOneMachineController) {
            return;
        }
        List<DynamicMachine> waitForLoadMachines = MachineRegistry.getWaitForLoadMachines();
        for (MachineBuilder builder : MachineBuilder.PRE_LOAD_MACHINES.values()) {
            waitForLoadMachines.add(builder.getMachine());
        }
        MachineBuilder.PRE_LOAD_MACHINES.clear();
        if (Config.mocCompatibleMode) {
            for (DynamicMachine machine : waitForLoadMachines) {
                if (machine.isFactoryOnly()) continue;
                ctrlBlock = RegistryBlocks.prepareRegisterWithCustomName(new BlockController("modularcontroller", machine));
                BlockController.MOC_MACHINE_CONTROLLERS.put(machine, ctrlBlock);
                ctrlBlockItem = (ItemBlockController)new ItemBlockController(ctrlBlock).setRegistryName(Objects.requireNonNull(ctrlBlock.getRegistryName()));
                RegistryBlocks.prepareItemBlockRegisterWithCustomName(ctrlBlockItem);
            }
        }
        for (DynamicMachine machine : waitForLoadMachines) {
            if (machine.isHasFactory() || Config.enableFactoryControllerByDefault) {
                BlockFactoryController factoryBlock = RegistryBlocks.prepareRegisterWithCustomName(new BlockFactoryController(machine));
                BlockFactoryController.FACTORY_CONTROLLERS.put(machine, factoryBlock);
                ctrlBlockItem = (ItemBlockController)new ItemBlockController(factoryBlock).setRegistryName(Objects.requireNonNull(factoryBlock.getRegistryName()));
                RegistryBlocks.prepareItemBlockRegisterWithCustomName(ctrlBlockItem);
            }
            if (machine.isFactoryOnly()) continue;
            ctrlBlock = RegistryBlocks.prepareRegisterWithCustomName(new BlockController(machine));
            BlockController.MACHINE_CONTROLLERS.put(machine, ctrlBlock);
            ctrlBlockItem = (ItemBlockController)new ItemBlockController(ctrlBlock).setRegistryName(Objects.requireNonNull(ctrlBlock.getRegistryName()));
            RegistryBlocks.prepareItemBlockRegisterWithCustomName(ctrlBlockItem);
        }
    }

    private static void registerBlockModels() {
        for (Block block : blockModelRegister) {
            ModularMachinery.proxy.registerBlockModel(block);
        }
    }

    private static void registerTile(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (String)name);
    }

    private static void registerTile(Class<? extends TileEntity> tile) {
        RegistryBlocks.registerTile(tile, tile.getSimpleName().toLowerCase());
    }

    private static void registerTileWithModID(Class<? extends TileEntity> aClass) {
        GameRegistry.registerTileEntity(aClass, (ResourceLocation)new ResourceLocation("modularmachinery", aClass.getSimpleName().toLowerCase()));
    }

    private static ItemBlock prepareItemBlockRegister(Block block) {
        if (block instanceof BlockMachineComponent) {
            if (block instanceof BlockMEMachineComponent) {
                return RegistryBlocks.prepareItemBlockRegister(new ItemBlockMEMachineComponent(block));
            }
            if (block instanceof BlockCustomName) {
                return RegistryBlocks.prepareItemBlockRegister(new ItemBlockMachineComponentCustomName(block));
            }
            return RegistryBlocks.prepareItemBlockRegister(new ItemBlockMachineComponent(block));
        }
        if (block instanceof BlockCustomName) {
            return RegistryBlocks.prepareItemBlockRegister(new ItemBlockCustomName(block));
        }
        return RegistryBlocks.prepareItemBlockRegister(new ItemBlock(block));
    }

    private static <T extends ItemBlock> T prepareItemBlockRegister(T item) {
        String name = item.func_179223_d().getClass().getSimpleName().toLowerCase();
        ((Item)item.setRegistryName("modularmachinery", name)).func_77655_b("modularmachinery." + name);
        RegistryItems.ITEM_BLOCKS.add((Item)item);
        return item;
    }

    private static <T extends ItemBlock> T prepareItemBlockRegisterWithCustomName(T item) {
        RegistryItems.ITEM_BLOCKS_WITH_CUSTOM_NAME.add((Item)item);
        return item;
    }

    private static <T extends Block> T prepareRegister(T block) {
        String name = block.getClass().getSimpleName().toLowerCase();
        ((Block)block.setRegistryName("modularmachinery", name)).func_149663_c("modularmachinery." + name);
        return RegistryBlocks.prepareRegisterWithCustomName(block);
    }

    private static <T extends Block> T prepareRegisterWithCustomName(T block) {
        blockModelRegister.add(block);
        CommonProxy.registryPrimer.register(block);
        if (block instanceof BlockDynamicColor) {
            pendingIBlockColorBlocks.add((BlockDynamicColor)block);
        }
        return block;
    }

    public static void writeAllCustomControllerModels() throws IOException {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        for (BlockController blockController : BlockController.MACHINE_CONTROLLERS.values()) {
            RegistryBlocks.writeMachineControllerModelInternal(resourceManager, blockController);
        }
        for (BlockFactoryController blockFactoryController : BlockFactoryController.FACTORY_CONTROLLERS.values()) {
            RegistryBlocks.writeFactoryControllerModelInternal(resourceManager, blockFactoryController);
        }
    }

    private static void writeMachineControllerModelInternal(IResourceManager resourceManager, BlockController controller) throws IOException {
        IResource blockStateResource = resourceManager.func_110536_a(new ResourceLocation("modularmachinery", "blockstates/block_machine_controller.json"));
        File blockStateFile = new File("resources/modularmachinery/blockstates/" + controller.getRegistryName().func_110623_a() + ".json");
        if (blockStateFile.exists()) {
            return;
        }
        InputStream inputStream = blockStateResource.func_110527_b();
        FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)blockStateFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        inputStream.close();
        fileOutputStream.close();
    }

    private static void writeFactoryControllerModelInternal(IResourceManager resourceManager, BlockFactoryController controller) throws IOException {
        IResource blockStateResource = resourceManager.func_110536_a(new ResourceLocation("modularmachinery", "blockstates/block_factory_controller.json"));
        File blockStateFile = new File("resources/modularmachinery/blockstates/" + controller.getRegistryName().func_110623_a() + ".json");
        if (blockStateFile.exists()) {
            return;
        }
        InputStream inputStream = blockStateResource.func_110527_b();
        FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)blockStateFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        inputStream.close();
        fileOutputStream.close();
    }
}

