/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktAssemblyReport
implements IMessage,
IMessageHandler<PktAssemblyReport, IMessage> {
    private List<List<ItemStack>> itemStackIngList = new ArrayList<List<ItemStack>>();
    private List<List<FluidStack>> fluidStackIngList = new ArrayList<List<FluidStack>>();

    public PktAssemblyReport() {
    }

    public PktAssemblyReport(List<List<ItemStack>> itemStackIngList, List<List<FluidStack>> fluidStackIngList) {
        this.itemStackIngList = itemStackIngList;
        this.fluidStackIngList = fluidStackIngList;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (tag == null) {
            return;
        }
        NBTTagList itemStackTagList = tag.func_150295_c("itemStackList", 9);
        for (int i = 0; i < itemStackTagList.func_74745_c(); ++i) {
            NBTTagList stackTagList = (NBTTagList)itemStackTagList.func_179238_g(i);
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            for (int i1 = 0; i1 < stackTagList.func_74745_c(); ++i1) {
                ItemStack stack;
                NBTTagCompound stackTag = stackTagList.func_150305_b(i1);
                if (stackTag.func_82582_d() || (stack = new ItemStack(stackTag)).func_190926_b()) continue;
                itemStackList.add(stack);
            }
            if (itemStackList.isEmpty()) continue;
            this.itemStackIngList.add(itemStackList);
        }
        NBTTagList fluidStackTagList = tag.func_150295_c("fluidStackList", 9);
        for (int i = 0; i < fluidStackTagList.func_74745_c(); ++i) {
            NBTTagList stackTagList = (NBTTagList)fluidStackTagList.func_179238_g(i);
            ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
            for (int i1 = 0; i1 < stackTagList.func_74745_c(); ++i1) {
                FluidStack stack;
                NBTTagCompound stackTag = stackTagList.func_150305_b(i1);
                if (stackTag.func_82582_d() || (stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackTag)) == null) continue;
                fluidStackList.add(stack);
            }
            if (fluidStackList.isEmpty()) continue;
            this.fluidStackIngList.add(fluidStackList);
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList itemStackIngTagList = new NBTTagList();
        for (List<ItemStack> itemStackList : this.itemStackIngList) {
            NBTTagList stackTagList = new NBTTagList();
            for (ItemStack stack : itemStackList) {
                NBTTagCompound stackTag = new NBTTagCompound();
                stack.func_77955_b(stackTag);
                stackTagList.func_74742_a((NBTBase)stackTag);
            }
            itemStackIngTagList.func_74742_a((NBTBase)stackTagList);
        }
        tag.func_74782_a("itemStackList", (NBTBase)itemStackIngTagList);
        NBTTagList fluidStackIngTagList = new NBTTagList();
        for (List<FluidStack> fluidStackList : this.fluidStackIngList) {
            NBTTagList stackTagList = new NBTTagList();
            for (FluidStack stack : fluidStackList) {
                NBTTagCompound stackTag = new NBTTagCompound();
                stack.writeToNBT(stackTag);
                stackTagList.func_74742_a((NBTBase)stackTag);
            }
            fluidStackIngTagList.func_74742_a((NBTBase)stackTagList);
        }
        tag.func_74782_a("fluidStackList", (NBTBase)fluidStackIngTagList);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PktAssemblyReport message, MessageContext ctx) {
        List<List<ItemStack>> itemStackIngList = message.itemStackIngList;
        List<List<FluidStack>> fluidStackIngList = message.fluidStackIngList;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.assembly.tip.required", new Object[0]));
        PktAssemblyReport.sendItemStackListMessage(itemStackIngList, (EntityPlayer)player);
        PktAssemblyReport.sendFluidStackListMessage(fluidStackIngList, (EntityPlayer)player);
        return null;
    }

    private static void sendItemStackListMessage(List<List<ItemStack>> itemStackIngList, EntityPlayer player) {
        for (List<ItemStack> stackList : itemStackIngList) {
            if (stackList.isEmpty()) continue;
            if (stackList.size() == 1) {
                ItemStack stack = stackList.get(0);
                player.func_145747_a((ITextComponent)new TextComponentString(PktAssemblyReport.itemStackToString(stack)));
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack stack = stackList.get(i);
                sb.append(PktAssemblyReport.itemStackToString(stack));
                if (i + 1 >= stackList.size()) continue;
                sb.append(" ").append(I18n.func_135052_a((String)"message.assembly.tip.or", (Object[])new Object[0])).append(" ");
            }
            player.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
        }
    }

    private static void sendFluidStackListMessage(List<List<FluidStack>> fluidStackIngList, EntityPlayer player) {
        for (List<FluidStack> stackList : fluidStackIngList) {
            if (stackList.isEmpty()) continue;
            if (stackList.size() == 1) {
                FluidStack stack = stackList.get(0);
                player.func_145747_a((ITextComponent)new TextComponentString(PktAssemblyReport.fluidStackToString(stack)));
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < stackList.size(); ++i) {
                FluidStack stack = stackList.get(i);
                sb.append(PktAssemblyReport.fluidStackToString(stack));
                if (i + 1 >= stackList.size()) continue;
                sb.append(" ").append(I18n.func_135052_a((String)"message.assembly.tip.or", (Object[])new Object[0])).append(" ");
            }
            player.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
        }
    }

    private static String itemStackToString(ItemStack stack) {
        return stack.func_190916_E() + "x " + stack.func_82833_r();
    }

    private static String fluidStackToString(FluidStack stack) {
        return stack.amount + "mb " + stack.getLocalizedName();
    }
}

