/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.concurrent.RecipeCraftingContextPool;
import github.kasuminova.mmce.common.concurrent.RecipeSearchTask;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import io.netty.util.internal.ThrowableUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.RecipeThread")
public abstract class RecipeThread {
    protected final TileMultiblockMachineController ctrl;
    protected final Map<String, RecipeModifier> permanentModifiers = new ConcurrentHashMap<String, RecipeModifier>();
    protected final Map<String, RecipeModifier> semiPermanentModifiers = new ConcurrentHashMap<String, RecipeModifier>();
    protected ActiveMachineRecipe activeRecipe = null;
    protected CraftingStatus status = CraftingStatus.IDLE;
    protected boolean waitForFinish = false;
    private RecipeCraftingContext context = null;
    protected RecipeSearchTask searchTask = null;

    protected RecipeThread(TileMultiblockMachineController ctrl) {
        this.ctrl = ctrl;
    }

    protected static ActiveMachineRecipe deserializeActiveRecipe(NBTTagCompound tag, TileMultiblockMachineController factory) {
        ActiveMachineRecipe activeRecipe = null;
        NBTTagCompound recipeTag = tag.func_74775_l("activeRecipe");
        if (tag.func_74764_b("activeRecipe")) {
            activeRecipe = new ActiveMachineRecipe(recipeTag);
        }
        if (activeRecipe != null && activeRecipe.getRecipe() == null) {
            activeRecipe = null;
            ModularMachinery.log.info("Couldn't find recipe named " + recipeTag.func_74779_i("recipeName") + " for controller at " + factory.func_174877_v());
        }
        return activeRecipe;
    }

    public CraftingStatus onTick() {
        if (this.activeRecipe == null) {
            return this.status;
        }
        if (this.context == null) {
            this.setContext(this.createContext(this.activeRecipe));
        }
        this.status = this.activeRecipe.tick(this.ctrl, this.context);
        return this.status;
    }

    public void onFinished() {
        RecipeCraftingContext.CraftingCheckResult checkResult;
        if (this.activeRecipe == null) {
            this.waitForFinish = false;
            return;
        }
        if (this.context == null) {
            this.setContext(this.createContext(this.activeRecipe));
        }
        if ((checkResult = this.context.canFinishCrafting()).isFailure()) {
            this.waitForFinish = true;
            this.status = CraftingStatus.failure(checkResult.getFirstErrorMessage(""));
            return;
        }
        this.waitForFinish = false;
        this.context.finishCrafting();
        this.fireFinishedEvent();
        this.semiPermanentModifiers.clear();
        this.tryRestartRecipe();
    }

    public boolean isCompleted() {
        return this.activeRecipe != null && this.activeRecipe.isCompleted();
    }

    public abstract void fireStartedEvent();

    public abstract void fireFinishedEvent();

    public abstract void tryRestartRecipe();

    public RecipeCraftingContext createContext(ActiveMachineRecipe activeRecipe) {
        RecipeCraftingContext context = this.ctrl.createContext(activeRecipe);
        context.addModifier(this.semiPermanentModifiers.values());
        context.addModifier(this.permanentModifiers.values());
        return context;
    }

    public void searchAndStartRecipe() {
        if (this.searchTask != null) {
            if (!this.searchTask.isDone()) {
                return;
            }
            this.ctrl.getTimeRecorder().addRecipeResearchUsedTime(this.searchTask.usedTime);
            RecipeCraftingContext context = null;
            try {
                context = (RecipeCraftingContext)this.searchTask.get();
                this.status = this.searchTask.getStatus();
            }
            catch (Exception e) {
                ModularMachinery.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
            }
            this.searchTask = null;
            if (context == null) {
                this.ctrl.incrementRecipeSearchRetryCount();
                return;
            }
            if (context.canStartCrafting().isSuccess()) {
                this.setContext(context);
                this.activeRecipe = context.getActiveRecipe();
                this.status = CraftingStatus.SUCCESS;
                this.fireStartedEvent();
            } else {
                RecipeCraftingContextPool.returnCtx(context);
            }
        } else if (this.shouldSearchRecipe()) {
            this.createRecipeSearchTask();
        }
    }

    protected boolean shouldSearchRecipe() {
        return this.ctrl.isSearchRecipeImmediately() || this.ctrl.getTicksExisted() % this.ctrl.currentRecipeSearchDelay() == 0;
    }

    public void invalidate() {
        this.setActiveRecipe(null).setContext(null);
        this.permanentModifiers.clear();
        this.semiPermanentModifiers.clear();
        if (this.searchTask == null || this.searchTask.isDone()) {
            return;
        }
        try {
            RecipeCraftingContext ctx = (RecipeCraftingContext)this.searchTask.get(50L, TimeUnit.MICROSECONDS);
            if (ctx != null) {
                RecipeCraftingContextPool.returnCtx(ctx);
            }
        }
        catch (TimeoutException ex) {
            ModularMachinery.log.warn("DIM: {} - {} controller is timeout to wait searchTask, discard search result.", (Object)this.ctrl.func_145831_w().func_72912_H().func_76065_j(), (Object)this.ctrl.func_174877_v());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.searchTask = null;
    }

    protected abstract void createRecipeSearchTask();

    public void flushContextModifier() {
        if (this.context == null) {
            return;
        }
        this.context.overrideModifier(MiscUtils.flatten(this.ctrl.getFoundModifiers().values()));
        this.context.addModifier(this.ctrl.getCustomModifiers().values());
        this.context.addModifier(this.semiPermanentModifiers.values());
        this.context.addModifier(this.permanentModifiers.values());
    }

    public RecipeThread setActiveRecipe(ActiveMachineRecipe activeRecipe) {
        this.activeRecipe = activeRecipe;
        return this;
    }

    public RecipeCraftingContext getContext() {
        return this.context;
    }

    public RecipeThread setContext(RecipeCraftingContext context) {
        if (this.context != null && this.context != context) {
            RecipeCraftingContextPool.returnCtx(this.context);
        }
        this.context = context;
        return this;
    }

    public CraftingStatus getStatus() {
        return this.status;
    }

    public RecipeThread setStatus(CraftingStatus status) {
        this.status = status;
        return this;
    }

    public boolean isWaitForFinish() {
        return this.waitForFinish;
    }

    public Map<String, RecipeModifier> getPermanentModifiers() {
        return this.permanentModifiers;
    }

    public Map<String, RecipeModifier> getSemiPermanentModifiers() {
        return this.semiPermanentModifiers;
    }

    @ZenGetter(value="activeRecipe")
    public ActiveMachineRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    @ZenMethod
    public void addModifier(String name, RecipeModifier modifier) {
        this.semiPermanentModifiers.put(name, modifier);
        this.flushContextModifier();
    }

    @ZenMethod
    public void removeModifier(String name) {
        RecipeModifier removed = this.semiPermanentModifiers.remove(name);
        if (removed != null) {
            this.flushContextModifier();
        }
    }

    @ZenMethod
    public boolean hasModifier(String name) {
        return this.semiPermanentModifiers.containsKey(name);
    }

    @ZenMethod
    public void addPermanentModifier(String name, RecipeModifier modifier) {
        this.permanentModifiers.put(name, modifier);
        this.flushContextModifier();
    }

    @ZenMethod
    public boolean hasPermanentModifier(String name) {
        return this.permanentModifiers.containsKey(name);
    }

    @ZenMethod
    public void removePermanentModifier(String name) {
        RecipeModifier removed = this.permanentModifiers.remove(name);
        if (removed != null) {
            this.flushContextModifier();
        }
    }

    @ZenMethod
    public void setStatusInfo(String info) {
        this.status = new CraftingStatus(this.status.getStatus(), info);
    }
}

