/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import crafttweaker.annotations.ZenRegister;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.data.DataLoadProfiler;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.ProgressManager;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MachineRegistry")
public class MachineRegistry
implements Iterable<DynamicMachine> {
    private static final MachineRegistry INSTANCE = new MachineRegistry();
    private static final Map<ResourceLocation, Tuple<DynamicMachine, String>> WAIT_FOR_LOAD_MACHINERY = new HashMap<ResourceLocation, Tuple<DynamicMachine, String>>();
    private static final Map<ResourceLocation, DynamicMachine> LOADED_MACHINERY = new HashMap<ResourceLocation, DynamicMachine>();

    private MachineRegistry() {
    }

    public static MachineRegistry getRegistry() {
        return INSTANCE;
    }

    @ZenMethod
    public static String[] getAllRegisteredMachinery() {
        return (String[])LOADED_MACHINERY.keySet().stream().map(rl -> rl.func_110624_b() + "." + rl.func_110623_a()).toArray(String[]::new);
    }

    public static void preloadMachines() {
        ProgressManager.ProgressBar barMachinery = ProgressManager.push((String)"MachineRegistry", (int)2);
        barMachinery.step("Discovering Files");
        DataLoadProfiler profiler = new DataLoadProfiler();
        Map<MachineLoader.FileType, List<File>> candidates = MachineLoader.discoverDirectory(CommonProxy.dataHolder.getMachineryDirectory());
        barMachinery.step("Registry Machines");
        DataLoadProfiler.StatusLine machines = profiler.createLine("Machines: ");
        DataLoadProfiler.Status success = machines.appendStatus("%s registered");
        DataLoadProfiler.Status failed = machines.appendStatus("%s failed");
        List<Tuple<DynamicMachine, String>> found = MachineLoader.registerMachines((Collection<File>)candidates.get((Object)MachineLoader.FileType.MACHINE));
        success.setCounter(found.size());
        Map<String, Exception> failures = MachineLoader.captureFailedAttempts();
        failed.setCounter(failures.size());
        if (!failures.isEmpty()) {
            ModularMachinery.log.warn("Encountered " + failures.size() + " problems while registering machinery!");
            for (String fileName : failures.keySet()) {
                ModularMachinery.log.warn("Couldn't load machinery " + fileName);
                failures.get(fileName).printStackTrace();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)barMachinery);
        for (Tuple<DynamicMachine, String> waitForRegistry : found) {
            WAIT_FOR_LOAD_MACHINERY.put(((DynamicMachine)waitForRegistry.func_76341_a()).getRegistryName(), waitForRegistry);
        }
    }

    public static Collection<DynamicMachine> loadMachines(@Nullable ICommandSender sender) {
        ProgressManager.ProgressBar barMachinery = ProgressManager.push((String)"MachineRegistry", (int)3);
        barMachinery.step("Discovering Files");
        DataLoadProfiler profiler = new DataLoadProfiler();
        Map<MachineLoader.FileType, List<File>> candidates = MachineLoader.discoverDirectory(CommonProxy.dataHolder.getMachineryDirectory());
        barMachinery.step("Loading Variables");
        MachineLoader.prepareContext(candidates.get((Object)MachineLoader.FileType.VARIABLES));
        DataLoadProfiler.StatusLine variables = profiler.createLine("Variables: ");
        DataLoadProfiler.Status success = variables.appendStatus("%s loaded");
        DataLoadProfiler.Status failed = variables.appendStatus("%s failed");
        success.setCounter(MachineLoader.VARIABLE_CONTEXT.size());
        Map<String, Exception> failures = MachineLoader.captureFailedAttempts();
        failed.setCounter(failures.size());
        if (!failures.isEmpty()) {
            ModularMachinery.log.warn("Encountered " + failures.size() + " problems while loading variables!");
            for (String fileName : failures.keySet()) {
                ModularMachinery.log.warn("Couldn't load variables of " + fileName);
                failures.get(fileName).printStackTrace();
            }
        }
        barMachinery.step("Loading Machines");
        DataLoadProfiler.StatusLine machines = profiler.createLine("Machines: ");
        success = machines.appendStatus("%s loaded");
        failed = machines.appendStatus("%s failed");
        List<DynamicMachine> found = MachineLoader.loadMachines(WAIT_FOR_LOAD_MACHINERY.values());
        WAIT_FOR_LOAD_MACHINERY.clear();
        success.setCounter(found.size());
        failures = MachineLoader.captureFailedAttempts();
        failed.setCounter(failures.size());
        if (!failures.isEmpty()) {
            ModularMachinery.log.warn("Encountered " + failures.size() + " problems while loading machinery!");
            for (String fileName : failures.keySet()) {
                ModularMachinery.log.warn("Couldn't load machinery " + fileName);
                failures.get(fileName).printStackTrace();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)barMachinery);
        profiler.printLines(sender);
        return Collections.unmodifiableList(found);
    }

    public static void registerMachines(Collection<DynamicMachine> machines) {
        for (DynamicMachine machine : machines) {
            LOADED_MACHINERY.put(machine.getRegistryName(), machine);
        }
    }

    public static void reloadMachine(Collection<DynamicMachine> machines) {
        for (DynamicMachine machine : machines) {
            DynamicMachine loaded = LOADED_MACHINERY.get(machine.getRegistryName());
            if (loaded != null) {
                loaded.mergeFrom(machine);
                continue;
            }
            LOADED_MACHINERY.put(machine.getRegistryName(), machine);
        }
    }

    public static List<DynamicMachine> getWaitForLoadMachines() {
        ArrayList<DynamicMachine> machineList = new ArrayList<DynamicMachine>();
        for (Tuple<DynamicMachine, String> value : WAIT_FOR_LOAD_MACHINERY.values()) {
            machineList.add((DynamicMachine)value.func_76341_a());
        }
        return machineList;
    }

    public static List<DynamicMachine> getLoadedMachines() {
        ArrayList<DynamicMachine> machineList = new ArrayList<DynamicMachine>(LOADED_MACHINERY.values());
        return Collections.unmodifiableList(machineList);
    }

    @Nullable
    public DynamicMachine getMachine(@Nullable ResourceLocation name) {
        if (name == null) {
            return null;
        }
        return LOADED_MACHINERY.get(name);
    }

    @Override
    public Iterator<DynamicMachine> iterator() {
        return LOADED_MACHINERY.values().iterator();
    }
}

