/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.concurrent.RecipeSearchTask;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import stanhebben.zenscript.annotations.ZenClass;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MachineRecipeThread")
public class MachineRecipeThread
extends RecipeThread {
    private final TileMachineController controller;

    public MachineRecipeThread(TileMachineController ctrl) {
        super(ctrl);
        this.controller = ctrl;
    }

    @Override
    public void fireStartedEvent() {
        this.controller.onStart();
    }

    @Override
    public void fireFinishedEvent() {
        this.controller.onFinished();
    }

    @Override
    public void tryRestartRecipe() {
        this.activeRecipe.reset();
        this.activeRecipe.setMaxParallelism(this.ctrl.getMaxParallelism());
        RecipeCraftingContext context = this.getContext().reset();
        this.flushContextModifier();
        RecipeCraftingContext.CraftingCheckResult result = this.ctrl.onRestartCheck(context);
        if (result.isSuccess()) {
            this.controller.onStart();
        } else {
            this.activeRecipe = null;
            this.setContext(null);
            this.status = CraftingStatus.failure(result.getFirstErrorMessage(""));
            this.createRecipeSearchTask();
        }
    }

    @Override
    protected boolean shouldSearchRecipe() {
        if (super.shouldSearchRecipe()) {
            this.ctrl.setSearchRecipeImmediately(false);
            return true;
        }
        return false;
    }

    @Override
    protected void createRecipeSearchTask() {
        TileMachineController controller = this.controller;
        assert (controller.getFoundMachine() != null);
        this.searchTask = new RecipeSearchTask(controller, controller.getFoundMachine(), controller.getMaxParallelism(), RecipeRegistry.getRecipesFor(controller.getFoundMachine()), this);
        ModularMachinery.EXECUTE_MANAGER.submitForkJoinTask(this.searchTask);
    }

    public NBTTagCompound serialize(NBTTagCompound tag) {
        NBTTagList tagList;
        tag.func_74782_a("statusTag", (NBTBase)this.status.serialize());
        if (this.activeRecipe != null && this.activeRecipe.getRecipe() != null) {
            tag.func_74782_a("activeRecipe", (NBTBase)this.activeRecipe.serialize());
        }
        if (!this.permanentModifiers.isEmpty()) {
            tagList = new NBTTagList();
            this.permanentModifiers.forEach((key, modifier) -> {
                if (key != null && modifier != null) {
                    NBTTagCompound modifierTag = new NBTTagCompound();
                    modifierTag.func_74778_a("key", key);
                    modifierTag.func_74782_a("modifier", (NBTBase)modifier.serialize());
                    tagList.func_74742_a((NBTBase)modifierTag);
                }
            });
            tag.func_74782_a("permanentModifiers", (NBTBase)tagList);
        }
        if (!this.semiPermanentModifiers.isEmpty()) {
            tagList = new NBTTagList();
            this.semiPermanentModifiers.forEach((key, modifier) -> {
                if (key != null && modifier != null) {
                    NBTTagCompound modifierTag = new NBTTagCompound();
                    modifierTag.func_74778_a("key", key);
                    modifierTag.func_74782_a("modifier", (NBTBase)modifier.serialize());
                    tagList.func_74742_a((NBTBase)modifierTag);
                }
            });
            tag.func_74782_a("semiPermanentModifiers", (NBTBase)tagList);
        }
        return tag;
    }

    public static MachineRecipeThread deserialize(NBTTagCompound tag, TileMachineController ctrl) {
        if (!tag.func_74764_b("statusTag")) {
            return null;
        }
        HashMap<String, RecipeModifier> permanentModifiers = new HashMap<String, RecipeModifier>();
        if (tag.func_150297_b("permanentModifiers", 9)) {
            NBTTagList tagList = tag.func_150295_c("permanentModifiers", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound modifierTag = tagList.func_150305_b(i);
                permanentModifiers.put(modifierTag.func_74779_i("key"), RecipeModifier.deserialize(modifierTag.func_74775_l("modifier")));
            }
        }
        HashMap<String, RecipeModifier> semiPermanentModifiers = new HashMap<String, RecipeModifier>();
        if (tag.func_150297_b("semiPermanentModifiers", 9)) {
            NBTTagList tagList = tag.func_150295_c("semiPermanentModifiers", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound modifierTag = tagList.func_150305_b(i);
                semiPermanentModifiers.put(modifierTag.func_74779_i("key"), RecipeModifier.deserialize(modifierTag.func_74775_l("modifier")));
            }
        }
        ActiveMachineRecipe activeRecipe = MachineRecipeThread.deserializeActiveRecipe(tag, ctrl);
        if (ctrl.getFoundMachine() != null && activeRecipe != null && !activeRecipe.getRecipe().getOwningMachineIdentifier().equals((Object)ctrl.getFoundMachine().getRegistryName())) {
            return new MachineRecipeThread(ctrl);
        }
        MachineRecipeThread thread = (MachineRecipeThread)new MachineRecipeThread(ctrl).setActiveRecipe(activeRecipe).setStatus(CraftingStatus.deserialize(tag.func_74775_l("statusTag")));
        thread.permanentModifiers.putAll(permanentModifiers);
        thread.semiPermanentModifiers.putAll(semiPermanentModifiers);
        return thread;
    }
}

