/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.DynamicMachinePreDeserializer;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.modifier.SingleBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.BlockInformationVariable;
import hellfirepvp.modularmachinery.common.util.FileUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.Tuple;

public class MachineLoader {
    public static final Map<String, BlockArray.BlockInformation> VARIABLE_CONTEXT = new HashMap<String, BlockArray.BlockInformation>();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(DynamicMachine.class, (Object)new DynamicMachine.MachineDeserializer()).registerTypeHierarchyAdapter(BlockInformationVariable.class, (Object)new BlockInformationVariable.Deserializer()).registerTypeHierarchyAdapter(SingleBlockModifierReplacement.class, (Object)new SingleBlockModifierReplacement.Deserializer()).registerTypeHierarchyAdapter(RecipeModifier.class, (Object)new RecipeModifier.Deserializer()).create();
    private static final Gson PRELOAD_GSON = new GsonBuilder().registerTypeHierarchyAdapter(DynamicMachine.class, (Object)new DynamicMachinePreDeserializer()).create();
    private static Map<String, Exception> failedAttempts = new HashMap<String, Exception>();

    public static Map<FileType, List<File>> discoverDirectory(File directory) {
        EnumMap<FileType, List<File>> candidates = new EnumMap<FileType, List<File>>(FileType.class);
        for (FileType type : FileType.values()) {
            candidates.put(type, Lists.newLinkedList());
        }
        LinkedList directories = Lists.newLinkedList();
        directories.add(directory);
        while (!directories.isEmpty()) {
            File dir = (File)directories.remove(0);
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    directories.addLast(file);
                    continue;
                }
                if (FileType.VARIABLES.accepts(file.getName())) {
                    ((List)candidates.get((Object)FileType.VARIABLES)).add(file);
                    continue;
                }
                if (!FileType.MACHINE.accepts(file.getName())) continue;
                ((List)candidates.get((Object)FileType.MACHINE)).add(file);
            }
        }
        return candidates;
    }

    public static List<Tuple<DynamicMachine, String>> registerMachines(Collection<File> machineCandidates) {
        ArrayList registeredMachinery = Lists.newArrayList();
        machineCandidates.parallelStream().forEach(file -> {
            block5: {
                try {
                    String jsonString = FileUtils.readFile(file);
                    DynamicMachine machine = (DynamicMachine)JsonUtils.func_193837_a((Gson)PRELOAD_GSON, (String)jsonString, DynamicMachine.class, (boolean)false);
                    if (machine == null) break block5;
                    List list = registeredMachinery;
                    synchronized (list) {
                        registeredMachinery.add(new Tuple((Object)machine, (Object)jsonString));
                    }
                }
                catch (Exception exc) {
                    failedAttempts.put(file.getPath(), exc);
                }
            }
        });
        return registeredMachinery;
    }

    public static List<DynamicMachine> loadMachines(Collection<Tuple<DynamicMachine, String>> registeredMachineList) {
        ArrayList<DynamicMachine> loadedMachines = new ArrayList<DynamicMachine>();
        registeredMachineList.parallelStream().forEach(registryAndJsonStr -> {
            block5: {
                DynamicMachine preloadMachine = (DynamicMachine)registryAndJsonStr.func_76341_a();
                try {
                    DynamicMachine loadedMachine = (DynamicMachine)JsonUtils.func_193837_a((Gson)GSON, (String)((String)registryAndJsonStr.func_76340_b()), DynamicMachine.class, (boolean)false);
                    if (loadedMachine == null) break block5;
                    preloadMachine.mergeFrom(loadedMachine);
                    List list = loadedMachines;
                    synchronized (list) {
                        loadedMachines.add(preloadMachine);
                    }
                }
                catch (Exception exc) {
                    ModularMachinery.log.warn((Object)preloadMachine.registryName, (Throwable)exc);
                }
            }
        });
        return loadedMachines;
    }

    public static Map<String, Exception> captureFailedAttempts() {
        Map<String, Exception> failed = failedAttempts;
        failedAttempts = new HashMap<String, Exception>();
        return failed;
    }

    public static void prepareContext(List<File> files) {
        VARIABLE_CONTEXT.clear();
        files.forEach(file -> {
            try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                Map<String, BlockArray.BlockInformation> variables = ((BlockInformationVariable)JsonUtils.func_193839_a((Gson)GSON, (Reader)isr, BlockInformationVariable.class)).getDefinedVariables();
                for (String key : variables.keySet()) {
                    VARIABLE_CONTEXT.put(key, variables.get(key));
                }
            }
            catch (Exception exc) {
                failedAttempts.put(file.getPath(), exc);
            }
        });
    }

    public static enum FileType {
        VARIABLES,
        MACHINE;


        public boolean accepts(String fileName) {
            boolean bl;
            switch (this) {
                case VARIABLES: {
                    bl = fileName.endsWith(".var.json");
                    break;
                }
                default: {
                    bl = fileName.endsWith(".json");
                }
            }
            return bl;
        }
    }
}

